/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.l10n;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.swing.l10n.IL10nPreference;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPane;
import in.gov.uidai.swing.l10n.MsgKeysCommon;
import java.awt.Component;
import java.util.Arrays;

public class L10nOptionPaneBuilder {
    private static L10nOptionPaneBuilder instance;
    private IResourceBundleContext resourceBundleContext;
    private IL10nPreference l10nPreference;

    private L10nOptionPaneBuilder() {
        instance = this;
    }

    public static synchronized L10nOptionPaneBuilder getInstance() {
        if (instance == null) {
            instance = new L10nOptionPaneBuilder();
        }
        return instance;
    }

    public void setResourceBundleContext(IResourceBundleContext _resourceBundleContext) {
        this.resourceBundleContext = _resourceBundleContext;
    }

    public void setL10nPreference(IL10nPreference _l10nPreference) {
        this.l10nPreference = _l10nPreference;
    }

    public void show(Component parent, int type, Object message, Object ... arguments) {
        if (message == null || message == "") {
            return;
        }
        L10nDecorator l10nDecorator = new L10nDecorator(this.resourceBundleContext, this.l10nPreference.getApplicationLocalize(false));
        L10nOptionPane.create(l10nDecorator).message(message, arguments).title(this.resourceBundleContext.getMessage((Object)MsgKeysCommon.TITLE, new Object[0])).messageType(type).optionType(-1).options(new Object[]{MsgKeysCommon.OK}).show(parent);
    }

    public void showError(Object message, Component parent, Object ... arguments) {
        if (message == null || message == "") {
            return;
        }
        this.createErrorPane().message(message, arguments).title(this.resourceBundleContext.getMessage((Object)MsgKeysCommon.TITLE, new Object[0])).show(parent);
    }

    public void showSimpleErrorUC(Object message, Component parent, Object ... arguments) {
        if (message == null || message == "") {
            return;
        }
        this.createErrorPane().message(message, arguments).title(this.resourceBundleContext.getMessage((Object)MsgKeysCommon.TITLE, new Object[0])).winIcon("uidlaf/images/frame_icon.png").showSimpleErrorPopupUC(parent, message);
    }

    public void showErrorUC(String message, Component parent, String errorCode, String txnId, Object ... arguments) {
        if (message == null || message.length() == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder(message);
        if (arguments.length > 0) {
            builder.append('\n');
            Arrays.stream(arguments).forEach(builder::append);
        }
        this.createErrorPane().components(builder.toString(), errorCode, txnId).title(this.resourceBundleContext.getMessage((Object)MsgKeysCommon.TITLE, new Object[0])).showErrorPopupUC(parent);
    }

    public void showWarningUC(Object message, Component parent) {
        if (message == null || message == "") {
            return;
        }
        this.createWarningPane().message(message, new Object[0]).title(this.resourceBundleContext.getMessage((Object)MsgKeysCommon.TITLE, new Object[0])).winIcon("uidlaf/images/frame_icon.png").showWarningPopupUC(this.resourceBundleContext.getMessage(message, new Object[0]), parent);
    }

    public void showInfo(Object message, Component parent, Object ... arguments) {
        if (message == null || message == "") {
            return;
        }
        this.createInfoPane().message(message, arguments).title(this.resourceBundleContext.getMessage((Object)MsgKeysCommon.TITLE, new Object[0])).show(parent);
    }

    public void showInfoUC(Object message) {
        if (message == null || message == "") {
            return;
        }
        this.createInfoPane().message(message, new Object[0]).title(this.resourceBundleContext.getMessage((Object)MsgKeysCommon.TITLE, new Object[0])).winIcon("uidlaf/images/frame_icon.png").showInfoPopupUC();
    }

    public void showWarning(Object message, Component parent) {
        if (message == null || message == "") {
            return;
        }
        this.createWarningPane().message(message, new Object[0]).title(this.resourceBundleContext.getMessage((Object)MsgKeysCommon.TITLE, new Object[0])).show(parent);
    }

    public MsgKeysCommon showYesNoConfirmation(Object message, Component parent) {
        if (message == null || message == "") {
            return null;
        }
        L10nOptionPane optionPane = this.createYesNoPane().message(message, new Object[0]).title(this.resourceBundleContext.getMessage((Object)MsgKeysCommon.TITLE, new Object[0])).options(new Object[]{MsgKeysCommon.YES, MsgKeysCommon.NO});
        Object option = optionPane.show(parent);
        return option == null || option.equals((Object)MsgKeysCommon.NO) ? MsgKeysCommon.NO : MsgKeysCommon.YES;
    }

    public MsgKeysCommon showYesNoUC(String message, Component parent) {
        if (message == null || message == "") {
            return null;
        }
        L10nOptionPane optionPane = this.createYesNoPane().message(message, new Object[0]).title(this.resourceBundleContext.getMessage((Object)MsgKeysCommon.TITLE, new Object[0])).options(new Object[]{MsgKeysCommon.YES, MsgKeysCommon.NO});
        Object option = optionPane.showInfoPopupUCTest(parent, message);
        return option.equals((Object)MsgKeysCommon.YES) ? MsgKeysCommon.YES : MsgKeysCommon.NO;
    }

    public L10nOptionPane createErrorPane() {
        L10nDecorator l10nDecorator = new L10nDecorator(this.resourceBundleContext, this.l10nPreference.getApplicationLocalize(false));
        return L10nOptionPane.create(l10nDecorator).messageType(0).optionType(-1).options(new Object[]{MsgKeysCommon.OK});
    }

    public L10nOptionPane createYesNoPane() {
        L10nDecorator l10nDecorator = new L10nDecorator(this.resourceBundleContext, this.l10nPreference.getApplicationLocalize(false));
        return L10nOptionPane.create(l10nDecorator).messageType(3).optionType(0);
    }

    public L10nOptionPane createInfoPane() {
        L10nDecorator l10nDecorator = new L10nDecorator(this.resourceBundleContext, this.l10nPreference.getApplicationLocalize(false));
        return L10nOptionPane.create(l10nDecorator).messageType(1).optionType(-1);
    }

    public L10nOptionPane createWarningPane() {
        L10nDecorator l10nDecorator = new L10nDecorator(this.resourceBundleContext, this.l10nPreference.getApplicationLocalize(false));
        return L10nOptionPane.create(l10nDecorator).messageType(2).optionType(-1);
    }
}

