/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.laf;

import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.laf.ColorConfiguration;
import in.gov.uidai.swing.laf.ComponentState;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import java.awt.Graphics;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import org.apache.commons.lang.StringUtils;

public class ButtonPainter
extends SynthPainter {
    private RoundedBorder buttonBorder = new RoundedBorder().rounding(3, 3);
    private LinearGradientBackground buttonBg = new LinearGradientBackground().direction(1).roundingSize(3, 3).borderSize(1.0f);
    private LinearGradientBackground toggleBg = new LinearGradientBackground().borderSize(0.0f).direction(1).roundingSize(10, 10);
    private LinearGradientBackground radioBg = new LinearGradientBackground().direction(1).roundingSize(7, 7).borderSize(0.0f);
    private LinearGradientBackground checkBg = new LinearGradientBackground().direction(1).roundingSize(0, 0).borderSize(0.0f);

    @Override
    public void paintButtonBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        String bgCol = ColorConfiguration.getBackgroundColor(ctxt, null, "#ffffff, #ffffff");
        String bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, null, "0, 1");
        if (StringUtils.isNotBlank((String)bgCol)) {
            this.buttonBg.gradientColors(bgCol);
        }
        if (StringUtils.isNotBlank((String)bgGrad)) {
            this.buttonBg.gradientStops(bgGrad);
        }
        this.buttonBg.doPaint(ctxt.getComponent(), g, x, y, w, h);
    }

    @Override
    public void paintButtonBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        String lineCol = ColorConfiguration.getBorderColor(ctxt, null, "#ffffff");
        if (StringUtils.isNotBlank((String)lineCol)) {
            this.buttonBorder.lineColor(lineCol);
        }
        if (ComponentState.isPressed(ctxt)) {
            this.buttonBorder.lineThickness(2.0f);
        } else if (ComponentState.isFocused(ctxt)) {
            this.buttonBorder.lineThickness(1.5f);
        } else if (ComponentState.isDisabled(ctxt)) {
            this.buttonBorder.lineThickness(1.0f);
        } else {
            this.buttonBorder.lineThickness(1.0f);
        }
        this.buttonBorder.paintBorder(ctxt.getComponent(), g, x, y, w, h);
    }

    @Override
    public void paintArrowButtonBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        this.paintButtonBackground(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintArrowButtonBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        this.paintButtonBorder(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintArrowButtonForeground(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int orientation) {
        super.paintArrowButtonForeground(ctxt, g, x, y, w, h, orientation);
    }

    @Override
    public void paintToggleButtonBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        String bgCol = ColorConfiguration.getBackgroundColor(ctxt, null, "#ffffff, #ffffff");
        String bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, null, "0, 1");
        if (!StringUtils.isBlank((String)bgCol)) {
            this.toggleBg.gradientColors(bgCol);
        }
        if (!StringUtils.isBlank((String)bgGrad)) {
            this.toggleBg.gradientStops(bgGrad);
        }
        this.toggleBg.doPaint(ctxt.getComponent(), g, x, y, w, h);
    }

    @Override
    public void paintToggleButtonBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintToggleButtonBorder(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintRadioButtonBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        String bgCol = ColorConfiguration.getBackgroundColor(ctxt, null, null);
        String bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, null, null);
        if (StringUtils.isBlank((String)bgCol) || StringUtils.isBlank((String)bgGrad)) {
            super.paintCheckBoxBackground(ctxt, g, x, y, w, h);
            return;
        }
        if (!StringUtils.isBlank((String)bgCol)) {
            this.radioBg.gradientColors(bgCol);
        }
        if (!StringUtils.isBlank((String)bgGrad)) {
            this.radioBg.gradientStops(bgGrad);
        }
        this.radioBg.doPaint(ctxt.getComponent(), g, x, y, 14, h);
    }

    @Override
    public void paintRadioButtonBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintRadioButtonBorder(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintCheckBoxBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        String bgCol = ColorConfiguration.getBackgroundColor(ctxt, null, null);
        String bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, null, null);
        if (StringUtils.isBlank((String)bgCol) || StringUtils.isBlank((String)bgGrad)) {
            super.paintCheckBoxBackground(ctxt, g, x, y, w, h);
            return;
        }
        if (!StringUtils.isBlank((String)bgCol)) {
            this.checkBg.gradientColors(bgCol);
        }
        if (!StringUtils.isBlank((String)bgGrad)) {
            this.checkBg.gradientStops(bgGrad);
        }
        this.checkBg.doPaint(ctxt.getComponent(), g, x - 2, y, 18, h);
    }

    @Override
    public void paintCheckBoxBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintCheckBoxBorder(ctxt, g, x, y, w, h);
    }
}

