/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.laf;

import in.gov.uidai.swing.laf.ComponentState;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import org.apache.commons.lang.StringUtils;

public final class ColorConfiguration {
    private ColorConfiguration() {
    }

    public static final String getBorderColor(SynthContext ctxt) {
        return ColorConfiguration.getBorderColor(ctxt, null, "");
    }

    public static final String getBorderColor(SynthContext ctxt, String suffix, String defaultValue) {
        String regionName = ctxt.getRegion().getName();
        String compState = ComponentState.toString(ctxt);
        String key = regionName + ".border.color." + compState;
        String defKey = regionName + ".border.color";
        return ColorConfiguration.getImpl(ctxt, key, defKey, suffix, defaultValue);
    }

    public static final String getBackgroundColor(SynthContext ctxt) {
        return ColorConfiguration.getBackgroundColor(ctxt, null, "");
    }

    public static final String getBackgroundColor(SynthContext ctxt, String suffix, String defaultValue) {
        String regionName = ctxt.getRegion().getName();
        String compState = ComponentState.toString(ctxt);
        String key = regionName + ".bg.color." + compState;
        String defKey = regionName + ".bg.color";
        return ColorConfiguration.getImpl(ctxt, key, defKey, suffix, defaultValue);
    }

    public static final String getBackgroundGradient(SynthContext ctxt) {
        return ColorConfiguration.getBackgroundGradient(ctxt, null, "");
    }

    public static final String getBackgroundGradient(SynthContext ctxt, String suffix, String defaultValue) {
        String regionName = ctxt.getRegion().getName();
        String compState = ComponentState.toString(ctxt);
        String key = regionName + ".bg.grad." + compState;
        String defKey = regionName + ".bg.grad";
        return ColorConfiguration.getImpl(ctxt, key, defKey, suffix, defaultValue);
    }

    private static final String getImpl(SynthContext ctxt, String key, String defKey, String suffix, String defaultValue) {
        String key0 = key;
        String defKey0 = defKey;
        if (StringUtils.isNotBlank((String)suffix)) {
            key0 = key0 + "." + suffix;
            defKey0 = defKey0 + "." + suffix;
        }
        SynthStyle style = ctxt.getStyle();
        String tempVal = style.getString(ctxt, defKey0, defaultValue);
        return style.getString(ctxt, key0, tempVal);
    }
}

