/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.laf;

import javax.swing.plaf.synth.SynthContext;

public final class ComponentState {
    private ComponentState() {
    }

    public static final boolean isFocused(SynthContext ctxt) {
        return (ctxt.getComponentState() & 0x100) == 256;
    }

    public static final boolean isDisabled(SynthContext ctxt) {
        return (ctxt.getComponentState() & 8) == 8;
    }

    public static final boolean isEnabled(SynthContext ctxt) {
        return (ctxt.getComponentState() & 1) == 1;
    }

    public static final boolean isMouseOver(SynthContext ctxt) {
        return (ctxt.getComponentState() & 2) == 2;
    }

    public static final boolean isSelected(SynthContext ctxt) {
        return (ctxt.getComponentState() & 0x200) == 512;
    }

    public static final boolean isPressed(SynthContext ctxt) {
        return (ctxt.getComponentState() & 4) == 4;
    }

    public static final String toString(SynthContext ctxt) {
        if (ComponentState.isDisabled(ctxt)) {
            return "disabled";
        }
        if (ComponentState.isPressed(ctxt)) {
            return "pressed";
        }
        if (ComponentState.isSelected(ctxt)) {
            return "selected";
        }
        if (ComponentState.isMouseOver(ctxt)) {
            return "mouseOver";
        }
        if (ComponentState.isFocused(ctxt)) {
            return "focused";
        }
        if (ComponentState.isEnabled(ctxt)) {
            return "enabled";
        }
        return "noState";
    }
}

