/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.laf;

import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.laf.ColorConfiguration;
import in.gov.uidai.swing.laf.ComponentState;
import in.gov.uidai.swing.notify.NotificationOverlay;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import in.gov.uidai.swing.painter.TextBackground;
import java.awt.Graphics;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import org.apache.commons.lang.StringUtils;

public class DropDownPainter
extends SynthPainter {
    public static final String KEY_WATERMARK_TEXT = "watermark-text";
    private final LinearGradientBackground comboBg = new LinearGradientBackground().direction(1).roundingSize(2, 2).borderSize(1.0f);
    private final RoundedBorder comboBorder = new RoundedBorder().rounding(3, 3).lineThickness(1.0f);
    private final TextBackground textBg = new TextBackground().textColor("#aaaaaa").clientPropertyKey("watermark-text");
    private final LinearGradientBackground errBg = new LinearGradientBackground().roundingSize(3, 3).borderSize(1.0f).direction(1).gradientColors("#ffffff, #ffffff, #f6ebea, #d99694").gradientStops("0, 0.4, 0.9, 1");
    private final RoundedBorder errBrdr = new RoundedBorder().rounding(3, 3).lineColor("#d99694").lineThickness(1.0f);

    @Override
    public void paintComboBoxBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        JComboBox combo;
        JComponent comp = ctxt.getComponent();
        if (comp.isEnabled() && NotificationOverlay.isError(comp)) {
            this.errBg.doPaint(comp, g, x, y, w, h);
        } else {
            String bgCol = ColorConfiguration.getBackgroundColor(ctxt, null, "#f4f4f3, #f4f4f3, #edeceb, #edeceb");
            String bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, null, "0, 0.45, 0.55, 1");
            if (StringUtils.isNotBlank((String)bgCol)) {
                this.comboBg.gradientColors(bgCol);
            }
            if (StringUtils.isNotBlank((String)bgGrad)) {
                this.comboBg.gradientStops(bgGrad);
            }
            this.comboBg.doPaint(comp, g, x, y, w, h);
        }
        if (comp instanceof JComboBox && !(combo = (JComboBox)comp).isPopupVisible() && combo.getSelectedIndex() <= 0) {
            this.textBg.doPaint(comp, g, x, y, w, h);
        }
    }

    @Override
    public void paintComboBoxBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        JComponent comp = ctxt.getComponent();
        if (comp.isEnabled() && NotificationOverlay.isError(comp)) {
            this.errBrdr.paintBorder(comp, g, x, y, w, h);
        } else {
            String lineCol = ColorConfiguration.getBorderColor(ctxt, null, "#ffffff");
            if (StringUtils.isNotBlank((String)lineCol)) {
                this.comboBorder.lineColor(lineCol);
            }
            if (ComponentState.isFocused(ctxt)) {
                this.comboBorder.lineThickness(2.0f);
            } else {
                this.comboBorder.lineThickness(1.0f);
            }
            this.comboBorder.paintBorder(comp, g, x, y, w, h);
        }
    }

    @Override
    public void paintListBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintListBackground(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintListBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
    }
}

