/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.laf;

import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.laf.ColorConfiguration;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import java.awt.Graphics;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class ProgressPainter
extends SynthPainter {
    private LinearGradientBackground progressBg = new LinearGradientBackground();
    private RoundedBorder progressBorder;
    private LinearGradientBackground progressFg;

    public ProgressPainter() {
        this.progressBg.borderSize(1.0f).direction(1).roundingSize(2, 2).gradientColors("#dddddd, #eeeeee, #eeeeee, #dddddd").gradientStops("0, 0.2, 0.8, 1");
        this.progressBorder = new RoundedBorder();
        this.progressBorder.lineThickness(1.0f).rounding(2, 2).lineColor("#a4a09d");
        this.progressFg = new LinearGradientBackground();
        this.progressFg.borderSize(0.0f).direction(1).roundingSize(2, 2).gradientColors("#a2c1e7, #84a9d8").gradientStops("0, 1");
    }

    @Override
    public void paintProgressBarBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int orientation) {
        this.progressBg.doPaint(ctxt.getComponent(), g, x, y, w, h);
    }

    @Override
    public void paintProgressBarBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        this.paintProgressBarBackground(ctxt, g, x, y, w, h, 0);
    }

    @Override
    public void paintProgressBarBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int orientation) {
        String borderColorSpec = ColorConfiguration.getBorderColor(ctxt, "track", "#a4a09d");
        String statusType = (String)ctxt.getComponent().getClientProperty("status");
        if (statusType != null && statusType.equalsIgnoreCase("fail")) {
            borderColorSpec = ColorConfiguration.getBorderColor(ctxt, "fail", "#a4a09d");
        }
        this.progressBorder.lineColor(borderColorSpec);
        this.progressBorder.paintBorder(ctxt.getComponent(), g, x, y, w, h);
    }

    @Override
    public void paintProgressBarBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        this.paintProgressBarBorder(ctxt, g, x, y, w, h, 0);
    }

    @Override
    public void paintProgressBarForeground(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int orientation) {
        if (w == 0 || h == 0) {
            return;
        }
        String fgColorSpec = ColorConfiguration.getBackgroundColor(ctxt, "track", "#a2c1e7, #84a9d8");
        String statusType = (String)ctxt.getComponent().getClientProperty("status");
        if (statusType != null && statusType.equalsIgnoreCase("pass")) {
            fgColorSpec = ColorConfiguration.getBackgroundColor(ctxt, "track.pass", "#a2c1e7, #84a9d8");
        }
        if (statusType != null && statusType.equalsIgnoreCase("fail")) {
            fgColorSpec = ColorConfiguration.getBackgroundColor(ctxt, "track.fail", "#a2c1e7, #84a9d8");
        }
        this.progressFg.gradientColors(fgColorSpec);
        this.progressFg.doPaint(ctxt.getComponent(), g, x, y, w, h);
    }
}

