/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.laf;

import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.laf.ColorConfiguration;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import java.awt.Graphics;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import org.apache.commons.lang.StringUtils;

public class ScrollPainter
extends SynthPainter {
    private LinearGradientBackground thumbBg = new LinearGradientBackground().borderSize(2.0f).roundingSize(0, 0);
    private RoundedBorder thumbBorder;
    private RoundedBorder thumbBorderInner = new RoundedBorder().rounding(0, 0).lineThickness(1.0f);
    private LinearGradientBackground trackBg;
    private RoundedBorder trackBorder;

    public ScrollPainter() {
        this.thumbBorder = new RoundedBorder().rounding(0, 0).lineThickness(1.0f);
        this.trackBorder = new RoundedBorder().rounding(0, 0).lineThickness(1.0f);
    }

    @Override
    public void paintScrollBarBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int orientation) {
        super.paintScrollBarBackground(ctxt, g, x, y, w, h, orientation);
    }

    @Override
    public void paintScrollBarBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintScrollBarBackground(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int orientation) {
        super.paintScrollBarBorder(ctxt, g, x, y, w, h, orientation);
    }

    @Override
    public void paintScrollBarBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintScrollBarBorder(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarThumbBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int orientation) {
        String bgCol = ColorConfiguration.getBackgroundColor(ctxt, null, "#a2c1e7, #a2c1e7, #84a9d8, #84a9d8");
        String bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, null, "0, 0.4, 0.6, 1");
        String innerbCol = ColorConfiguration.getBorderColor(ctxt, "inner", "#b0cbec");
        if (!StringUtils.isBlank((String)bgCol)) {
            this.thumbBg.gradientColors(bgCol);
        }
        if (!StringUtils.isBlank((String)bgGrad)) {
            this.thumbBg.gradientStops(bgGrad);
        }
        if (!StringUtils.isBlank((String)innerbCol)) {
            this.thumbBorderInner.lineColor(innerbCol);
        }
        switch (orientation) {
            case 0: {
                this.thumbBg.direction(1);
                break;
            }
            case 1: {
                this.thumbBg.direction(0);
            }
        }
        this.thumbBg.doPaint(ctxt.getComponent(), g, x, y, w, h);
        this.thumbBorderInner.paintBorder(ctxt.getComponent(), g, x + 1, y + 1, w - 2, h - 2);
    }

    @Override
    public void paintScrollBarThumbBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int orientation) {
        String lineCol = ColorConfiguration.getBorderColor(ctxt, null, "#5e7ea5");
        this.thumbBorder.lineColor(lineCol);
        this.thumbBorder.paintBorder(ctxt.getComponent(), g, x, y, w, h);
    }

    @Override
    public void paintScrollBarTrackBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int arg6) {
        super.paintScrollBarTrackBackground(ctxt, g, x, y, w, h, arg6);
    }

    @Override
    public void paintScrollBarTrackBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintScrollBarTrackBackground(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarTrackBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paintScrollBarTrackBorder(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintScrollBarTrackBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        String lineCol = ColorConfiguration.getBorderColor(ctxt, null, "#a19d9a");
        this.trackBorder.lineColor(lineCol);
        this.trackBorder.paintBorder(ctxt.getComponent(), g, x, y, w, h);
    }

    @Override
    public void paintScrollPaneBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintScrollPaneBackground(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintScrollPaneBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintScrollPaneBorder(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintViewportBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
    }

    @Override
    public void paintViewportBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
    }
}

