/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.laf;

import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.laf.ColorConfiguration;
import in.gov.uidai.swing.laf.ComponentState;
import in.gov.uidai.swing.notify.NotificationOverlay;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import in.gov.uidai.swing.painter.TextBackground;
import java.awt.Graphics;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public class SingleLineTextPainter
extends SynthPainter {
    public static final String KEY_WATERMARK_TEXT = "watermark-text";
    private final RoundedBorder border = new RoundedBorder().rounding(3, 3);
    private final RoundedBorder errBrdr;
    private final LinearGradientBackground background = new LinearGradientBackground().roundingSize(3, 3).borderSize(1.0f).direction(1).gradientColors("#ffffff, #ffffff").gradientStops("0, 1");
    private final TextBackground textBg = new TextBackground().textColor("#aaaaaa").clientPropertyKey("watermark-text");
    private final LinearGradientBackground errBg = new LinearGradientBackground().roundingSize(3, 3).borderSize(1.0f).direction(1).gradientColors("#ffffff, #ffffff, #f6ebea, #d99694").gradientStops("0, 0.4, 0.9, 1");

    public SingleLineTextPainter() {
        this.errBrdr = new RoundedBorder().rounding(3, 3).lineColor("#d99694").lineThickness(1.0f);
    }

    @Override
    public void paintTextFieldBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        JTextComponent comp = (JTextComponent)ctxt.getComponent();
        if (comp.isEnabled() && NotificationOverlay.isError(comp)) {
            this.errBg.doPaint(comp, g, x, y, w, h);
        } else {
            this.background.doPaint(comp, g, x, y, w, h);
        }
        if (!comp.hasFocus() && StringUtils.isBlank((String)comp.getText())) {
            this.textBg.doPaint(comp, g, x, y, w, h);
        }
    }

    @Override
    public void paintTextFieldBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        JTextComponent comp = (JTextComponent)ctxt.getComponent();
        if (comp.isEnabled() && NotificationOverlay.isError(comp)) {
            this.errBrdr.paintBorder(comp, g, x, y, w, h);
        } else {
            String lineCol = ColorConfiguration.getBorderColor(ctxt, null, "#6d89ab");
            if (StringUtils.isNotBlank((String)lineCol)) {
                this.border.lineColor(lineCol);
            }
            if (ComponentState.isFocused(ctxt)) {
                this.border.lineThickness(2.0f);
            } else {
                this.border.lineThickness(1.0f);
            }
            this.border.paintBorder(comp, g, x, y, w, h);
        }
    }

    @Override
    public void paintPasswordFieldBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        this.paintTextFieldBackground(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintPasswordFieldBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        this.paintTextFieldBorder(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintFormattedTextFieldBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        this.paintTextFieldBackground(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintFormattedTextFieldBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        this.paintTextFieldBorder(ctxt, g, x, y, w, h);
    }
}

