/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.laf;

import in.gov.uidai.swing.border.SingleLineBorder;
import in.gov.uidai.swing.laf.ColorConfiguration;
import in.gov.uidai.swing.laf.ComponentState;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTabbedPane;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import org.apache.commons.lang.StringUtils;

public class TabPainter
extends SynthPainter {
    private SingleLineBorder tabAreaBorder = new SingleLineBorder().lineThickness(1.0f);
    private LinearGradientBackground tabAreaBg = new LinearGradientBackground().roundingSize(2, 2).borderSize(1.0f);
    private SingleLineBorder tabBorder = new SingleLineBorder().lineThickness(1.0f).dashInterval("0, 7, 15");
    private LinearGradientBackground tabBg = new LinearGradientBackground().roundingSize(0, 0).borderSize(1.0f);

    @Override
    public void paintTabbedPaneBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintTabbedPaneBackground(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintTabbedPaneBorder(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneContentBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintTabbedPaneContentBackground(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneContentBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintTabbedPaneContentBorder(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabAreaBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int orientation) {
        if (orientation == 1 || orientation == 5) {
            this.tabAreaBg.direction(1);
        } else {
            this.tabAreaBg.direction(0);
        }
        String bgCol = null;
        String bgGrad = null;
        if (orientation == 1) {
            bgCol = ColorConfiguration.getBackgroundColor(ctxt, "top", "#f4f4f3, #f4f4f3, #edeceb, #edeceb");
            bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, "top", "0, 0.45, 0.55, 1");
        } else if (orientation == 7) {
            bgCol = ColorConfiguration.getBackgroundColor(ctxt, "left", "#f4f4f3, #f4f4f3, #edeceb, #edeceb");
            bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, "left", "0, 0.45, 0.55, 1");
        } else if (orientation == 5) {
            bgCol = ColorConfiguration.getBackgroundColor(ctxt, "bottom", "#edeceb, #edeceb, #f4f4f3, #f4f4f3");
            bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, "bottom", "0, 0.45, 0.55, 1");
        } else if (orientation == 3) {
            bgCol = ColorConfiguration.getBackgroundColor(ctxt, "right", "#edeceb, #edeceb, #f4f4f3, #f4f4f3");
            bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, "right", "0, 0.45, 0.55, 1");
        }
        if (StringUtils.isNotBlank((String)bgCol)) {
            this.tabAreaBg.gradientColors(bgCol);
        }
        if (StringUtils.isNotBlank((String)bgGrad)) {
            this.tabAreaBg.gradientStops(bgGrad);
        }
        this.tabAreaBg.doPaint(ctxt.getComponent(), g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabAreaBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        this.paintTabbedPaneTabAreaBackground(ctxt, g, x, y, w, h, 1);
    }

    @Override
    public void paintTabbedPaneTabAreaBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int orientation) {
        String lineCol = ColorConfiguration.getBorderColor(ctxt, null, "#cccccc");
        this.tabAreaBorder.lineColor(lineCol);
        switch (orientation) {
            case 1: {
                this.tabAreaBorder.drawEdges(false, false, true, false);
                break;
            }
            case 7: {
                this.tabAreaBorder.drawEdges(false, false, false, true);
                break;
            }
            case 5: {
                this.tabAreaBorder.drawEdges(true, false, false, false);
                break;
            }
            case 3: {
                this.tabAreaBorder.drawEdges(false, true, false, false);
            }
        }
        this.tabAreaBorder.paintBorder(ctxt.getComponent(), g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabAreaBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        this.paintTabbedPaneTabAreaBorder(ctxt, g, x, y, w, h, 1);
    }

    @Override
    public void paintTabbedPaneTabBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int tabIndex, int orientation) {
        JTabbedPane tabPane = (JTabbedPane)ctxt.getComponent();
        Rectangle tabBounds = tabPane.getBoundsAt(tabIndex);
        if (orientation == 1 || orientation == 5) {
            this.tabBg.direction(1);
        } else {
            this.tabBg.direction(0);
        }
        String bgCol = null;
        String bgGrad = null;
        if (orientation == 1) {
            bgCol = ColorConfiguration.getBackgroundColor(ctxt, "top", null);
            bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, "top", null);
        } else if (orientation == 7) {
            bgCol = ColorConfiguration.getBackgroundColor(ctxt, "left", null);
            bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, "left", null);
        } else if (orientation == 5) {
            bgCol = ColorConfiguration.getBackgroundColor(ctxt, "bottom", null);
            bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, "bottom", null);
        } else if (orientation == 3) {
            bgCol = ColorConfiguration.getBackgroundColor(ctxt, "right", null);
            bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, "right", null);
        }
        if (StringUtils.isBlank((String)bgCol) || StringUtils.isBlank((String)bgGrad)) {
            return;
        }
        if (StringUtils.isNotBlank((String)bgCol)) {
            this.tabBg.gradientColors(bgCol);
        }
        if (StringUtils.isNotBlank((String)bgGrad)) {
            this.tabBg.gradientStops(bgGrad);
        }
        this.tabBg.doPaint(ctxt.getComponent(), g, tabBounds.x, tabBounds.y, tabBounds.width, tabBounds.height);
    }

    @Override
    public void paintTabbedPaneTabBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int tabIndex) {
        this.paintTabbedPaneTabBackground(ctxt, g, x, y, w, h, tabIndex, 1);
    }

    @Override
    public void paintTabbedPaneTabBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int tabIndex, int orientation) {
        if (ComponentState.isSelected(ctxt) && ComponentState.isEnabled(ctxt)) {
            return;
        }
        JTabbedPane tabPane = (JTabbedPane)ctxt.getComponent();
        Rectangle tabBounds = tabPane.getBoundsAt(tabIndex);
        int selIndex = tabPane.getSelectedIndex();
        if (selIndex - tabIndex == 1 && tabIndex > 0) {
            return;
        }
        String lineCol = ColorConfiguration.getBorderColor(ctxt, null, "#cccccc");
        if (StringUtils.isBlank((String)lineCol)) {
            return;
        }
        this.tabBorder.lineColor(lineCol);
        switch (orientation) {
            case 1: 
            case 5: {
                if (tabIndex == 0) {
                    if (selIndex - tabIndex == 1) {
                        this.tabBorder.drawEdges(false, true, false, false);
                        break;
                    }
                    this.tabBorder.drawEdges(false, true, false, true);
                    break;
                }
                this.tabBorder.drawEdges(false, false, false, true);
                break;
            }
            case 3: 
            case 7: {
                if (tabIndex == 0) {
                    if (selIndex - tabIndex == 1) {
                        this.tabBorder.drawEdges(true, false, false, false);
                        break;
                    }
                    this.tabBorder.drawEdges(true, false, true, false);
                    break;
                }
                this.tabBorder.drawEdges(false, false, true, false);
            }
        }
        this.tabBorder.paintBorder(ctxt.getComponent(), g, tabBounds.x, tabBounds.y, tabBounds.width, tabBounds.height);
    }

    @Override
    public void paintTabbedPaneTabBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h, int tabIndex) {
        this.paintTabbedPaneTabBorder(ctxt, g, x, y, w, h, tabIndex, 1);
    }
}

