/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.laf;

import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.border.SingleLineBorder;
import in.gov.uidai.swing.laf.ColorConfiguration;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class TablePainter
extends SynthPainter {
    private LinearGradientBackground thBg = new LinearGradientBackground().direction(1).roundingSize(2, 2).borderSize(1.0f);
    private SingleLineBorder thBgBorder = new SingleLineBorder().drawEdges(false, false, false, true).lineThickness(1.0f);
    private RoundedBorder thBorder = new RoundedBorder().lineColor("#999999").lineThickness(1.0f).rounding(2, 2);

    @Override
    public void paintTableBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
    }

    @Override
    public void paintTableBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        super.paintTableBorder(ctxt, g, x, y, w, h);
    }

    @Override
    public void paintTableHeaderBackground(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        String bgCol = ColorConfiguration.getBackgroundColor(ctxt, null, "#f4f4f3, #f4f4f3, #edeceb, #edeceb");
        String bgGrad = ColorConfiguration.getBackgroundGradient(ctxt, null, "0, 0.45, 0.55, 1");
        String borderCol = ColorConfiguration.getBorderColor(ctxt, null, "#bbbbbb");
        this.thBg.gradientColors(bgCol).gradientStops(bgGrad).doPaint(ctxt.getComponent(), g, x, y, w, h);
        this.thBgBorder.lineColor(borderCol);
        JTableHeader th = (JTableHeader)ctxt.getComponent();
        TableColumnModel model = th.getColumnModel();
        int colCount = model.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            Rectangle tileRect = th.getHeaderRect(i);
            int lineLen = tileRect.height - 9;
            if (lineLen > 0) {
                this.thBgBorder.dashInterval("0, 4, " + lineLen + ", 5");
            }
            this.thBgBorder.paintBorder(th, g, tileRect.x, tileRect.y, tileRect.width, tileRect.height);
        }
    }

    @Override
    public void paintTableHeaderBorder(SynthContext ctxt, Graphics g, int x, int y, int w, int h) {
        String lineCol = ColorConfiguration.getBorderColor(ctxt, null, "#bbbbbb");
        this.thBorder.lineColor(lineCol);
        this.thBorder.paintBorder(ctxt.getComponent(), g, x, y, w, h);
    }
}

