/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.laf;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.plaf.synth.SynthLookAndFeel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UidLookAndFeel
extends SynthLookAndFeel {
    private static final Logger LOGGER = LoggerFactory.getLogger(UidLookAndFeel.class);

    public UidLookAndFeel() throws Exception {
        HashMap<TextAttribute, Object> attribs = new HashMap<TextAttribute, Object>();
        attribs.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
        this.registerFont("uidlaf/fonts/arial.ttf", attribs);
        InputStream input = this.getClass().getResourceAsStream("/uidlaf/laf.xml");
        super.load(input, this.getClass());
        input.close();
    }

    @Override
    public String getID() {
        return "uidlaf";
    }

    @Override
    public String getName() {
        return "UID Looks";
    }

    @Override
    public String getDescription() {
        return "Custom Look and Feel for UID";
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFont(String path, Map<TextAttribute, Object> attribs) {
        InputStream input = null;
        try {
            input = this.getClass().getClassLoader().getResourceAsStream(path);
            Font font = Font.createFont(0, input);
            if (attribs != null && !attribs.isEmpty()) {
                HashMap fontAttrib = new HashMap(font.getAttributes());
                fontAttrib.putAll(attribs);
                font = font.deriveFont(attribs);
            }
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
        }
        catch (Exception exep) {
            LOGGER.error("Error registering font", (Throwable)exep);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception exep) {
                LOGGER.error("Error closing input while registering font", (Throwable)exep);
            }
        }
    }
}

