/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.notify;

import java.awt.Image;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class AlwaysOnTopOptionPane {
    private Object message;
    private int messageType;
    private int optionType;
    private Icon icon;
    private Object[] options;
    private Object initialValue;
    private String title;
    private Image winIcon;

    private AlwaysOnTopOptionPane() {
    }

    public static AlwaysOnTopOptionPane create() {
        return new AlwaysOnTopOptionPane();
    }

    public AlwaysOnTopOptionPane winIcon(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            this.winIcon = new ImageIcon(Objects.requireNonNull(cl.getResource(path))).getImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public AlwaysOnTopOptionPane message(String msg) {
        this.message = msg;
        return this;
    }

    public AlwaysOnTopOptionPane messageType(int type) {
        this.messageType = type;
        return this;
    }

    public AlwaysOnTopOptionPane optionType(int type) {
        this.optionType = type;
        return this;
    }

    public AlwaysOnTopOptionPane icon(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            this.icon = new ImageIcon(cl.getResource(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public AlwaysOnTopOptionPane options(Object ... opts) {
        this.options = opts;
        return this;
    }

    public AlwaysOnTopOptionPane initialValue(Object value) {
        this.initialValue = value;
        return this;
    }

    public AlwaysOnTopOptionPane title(String value) {
        this.title = value;
        return this;
    }

    public Object show() {
        JOptionPane opt = new JOptionPane(this.message, this.messageType, this.optionType, this.icon, this.options, this.initialValue);
        JDialog dlg = opt.createDialog(this.title);
        dlg.setIconImage(this.winIcon);
        dlg.setAlwaysOnTop(true);
        dlg.setVisible(true);
        return opt.getValue();
    }
}

