/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.notify;

import in.gov.uidai.swing.border.DashedBorder;
import in.gov.uidai.swing.notify.NotificationLocation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang.StringUtils;

public final class NotificationPopup {
    private static final String DEFAULT_NAME = "default-popup";
    private final JComponent theComp;
    private final JLabel label;
    private final Timer hideTimer;
    private Popup popup;
    private String tipText;
    private String tempTipText;
    private NotificationLocation notLoc;
    private Point notLocPt;

    private NotificationPopup(JComponent comp, String name) {
        this.theComp = comp;
        this.theComp.putClientProperty(name, this);
        if (this.theComp instanceof JComboBox) {
            ((JComboBox)this.theComp).addPopupMenuListener(new PopupMenuTrigger());
        } else {
            JPopupMenu popup = this.theComp.getComponentPopupMenu();
            if (popup != null) {
                popup.addPopupMenuListener(new PopupMenuTrigger());
            }
        }
        this.label = new JLabel();
        CompoundBorder cb = new CompoundBorder(new DashedBorder().dashInterval("1.2, 1.2").lineColor("#baba45").lineThickness(1.0f), new EmptyBorder(5, 5, 5, 5));
        this.label.setBorder(cb);
        this.label.setBackground(Color.decode("#f5f5b5"));
        this.label.setOpaque(true);
        AbstractAction hideAxn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationPopup.this.hideToolTip();
                NotificationPopup.this.tempTipText = null;
            }
        };
        this.hideTimer = new Timer(5000, hideAxn);
        this.hideTimer.setRepeats(false);
        this.theComp.addFocusListener(new FocusTrigger());
        this.theComp.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "hideNotificationPopup");
        this.theComp.getActionMap().put("hideNotificationPopup", hideAxn);
        AbstractAction showAxn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationPopup.this.showToolTip();
            }
        };
        this.theComp.getInputMap().put(KeyStroke.getKeyStroke("F1"), "showNotificationPopup");
        this.theComp.getActionMap().put("showNotificationPopup", showAxn);
    }

    public static NotificationPopup getToolTip(JComponent comp) {
        return NotificationPopup.getToolTip(comp, DEFAULT_NAME);
    }

    public static NotificationPopup getToolTip(JComponent comp, String name) {
        NotificationPopup notpop = (NotificationPopup)comp.getClientProperty(name);
        if (notpop == null) {
            notpop = new NotificationPopup(comp, name);
        }
        return notpop;
    }

    public void setToolTipText(String text, boolean temporary) {
        if (temporary) {
            this.tempTipText = text;
        } else {
            this.tipText = text;
        }
    }

    public void setLocation(NotificationLocation nl) {
        this.notLoc = nl;
        this.notLocPt = null;
    }

    public void setLocation(Point pt) {
        this.notLocPt = pt;
        this.notLoc = null;
    }

    public void showToolTip() {
        this.hideToolTip();
        if (this.tempTipText == null && this.tipText == null) {
            return;
        }
        if (!this.theComp.isShowing()) {
            return;
        }
        if (this.tempTipText != null) {
            if (!StringUtils.startsWithIgnoreCase((String)this.tempTipText, (String)"<html>")) {
                this.tempTipText = "<html>" + this.tempTipText;
            }
            this.label.setText(this.tempTipText);
        } else if (this.tipText != null) {
            if (!StringUtils.startsWithIgnoreCase((String)this.tipText, (String)"<html>")) {
                this.tipText = "<html>" + this.tipText;
            }
            this.label.setText(this.tipText);
        }
        if (this.notLocPt != null) {
            int y;
            Dimension scrnDim = Toolkit.getDefaultToolkit().getScreenSize();
            Point scrnPt = this.theComp.getLocationOnScreen();
            int x = scrnPt.x + this.notLocPt.x;
            if (x < 0 || x > scrnDim.width) {
                x = 0;
            }
            if ((y = this.notLocPt.y) < 0 || y > scrnDim.height) {
                y = 0;
            }
            this.popup = PopupFactory.getSharedInstance().getPopup(this.theComp, this.label, x + 30, y);
        } else {
            Point loc = this.computeRelativeLocation();
            this.popup = PopupFactory.getSharedInstance().getPopup(this.theComp, this.label, loc.x, loc.y);
        }
        this.popup.show();
        this.hideTimer.restart();
    }

    public void showToolTip(String text, boolean temporary) {
        this.setToolTipText(text, temporary);
        this.showToolTip();
    }

    public void showToolTip(String text, Point loc, boolean temporary) {
        this.setToolTipText(text, temporary);
        this.setLocation(loc);
        this.showToolTip();
    }

    public void showToolTip(String text, NotificationLocation loc, boolean temporary) {
        this.setToolTipText(text, temporary);
        this.setLocation(loc);
        this.showToolTip();
    }

    public void hideToolTip() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        this.hideTimer.stop();
    }

    private Point computeRelativeLocation() {
        Point result = this.theComp.getLocationOnScreen();
        if (this.notLoc == null) {
            return result;
        }
        if (this.notLoc.equals((Object)NotificationLocation.TOP)) {
            result.y -= this.label.getPreferredSize().height;
            return result;
        }
        if (this.notLoc.equals((Object)NotificationLocation.RIGHT)) {
            result.x += this.theComp.getWidth();
            return result;
        }
        if (this.notLoc.equals((Object)NotificationLocation.BOTTOM)) {
            result.y += this.theComp.getHeight();
            return result;
        }
        if (this.notLoc.equals((Object)NotificationLocation.OVERLAY)) {
            result.x += 10;
            result.y += 10;
            return result;
        }
        return result;
    }

    private class PopupMenuTrigger
    implements PopupMenuListener {
        private PopupMenuTrigger() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent evt) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            NotificationPopup.this.hideToolTip();
            NotificationPopup.this.notLoc = NotificationLocation.BOTTOM;
            NotificationPopup.this.showToolTip();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            NotificationPopup.this.hideToolTip();
            NotificationPopup.this.notLoc = NotificationLocation.TOP;
            NotificationPopup.this.showToolTip();
        }
    }

    private class FocusTrigger
    implements FocusListener {
        private FocusTrigger() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            try {
                NotificationPopup.this.showToolTip();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            try {
                NotificationPopup.this.hideToolTip();
                NotificationPopup.this.tempTipText = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

