/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.painter;

import in.gov.uidai.swing.painter.IPaintDelegate;
import in.gov.uidai.swing.util.UidSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RenderingHints;
import org.apache.commons.lang.ArrayUtils;

public class LinearGradientBackground
implements IPaintDelegate {
    private int roundWidth;
    private int roundHeight;
    private int direction;
    private float borderSize;
    private Color[] gradientColors;
    private float[] gradientFractions;

    public LinearGradientBackground roundingSize(int width, int height) {
        this.roundHeight = height;
        this.roundWidth = width;
        return this;
    }

    public LinearGradientBackground direction(int direction) {
        this.direction = direction;
        return this;
    }

    public LinearGradientBackground borderSize(float size) {
        this.borderSize = size;
        return this;
    }

    public LinearGradientBackground gradientStops(String stopSpec) {
        String[] stops = stopSpec.split(",");
        this.gradientFractions = new float[stops.length];
        for (int i = 0; i < this.gradientFractions.length; ++i) {
            this.gradientFractions[i] = Float.parseFloat(stops[i].trim());
        }
        return this;
    }

    public LinearGradientBackground gradientColors(String colorSpec) {
        String[] colors = colorSpec.split(",");
        this.gradientColors = new Color[colors.length];
        for (int i = 0; i < this.gradientColors.length; ++i) {
            this.gradientColors[i] = UidSwingUtilities.decodeColorWithAlpha(colors[i].trim());
        }
        return this;
    }

    @Override
    public void doPaint(Component comp, Graphics g, int x, int y, int width, int height) {
        LinearGradientPaint paint;
        if (ArrayUtils.isEmpty((float[])this.gradientFractions) || ArrayUtils.isEmpty((Object[])this.gradientColors)) {
            return;
        }
        if (width == 0 || height == 0) {
            return;
        }
        if (this.direction == 0) {
            paint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, this.gradientFractions, this.gradientColors);
        } else if (this.direction == 1) {
            paint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, this.gradientFractions, this.gradientColors);
        } else {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g.translate(x, y);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Color oldCol = g2.getColor();
        Paint oldPaint = g2.getPaint();
        g2.setPaint(paint);
        g2.fillRoundRect(Math.round(this.borderSize) / 2, Math.round(this.borderSize) / 2, width - Math.round(this.borderSize), height - Math.round(this.borderSize), this.roundWidth * 2, this.roundHeight * 2);
        g.translate(-x, -y);
        g2.setColor(oldCol);
        g2.setPaint(oldPaint);
    }
}

