/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.painter;

import in.gov.uidai.swing.painter.IPaintDelegate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import org.apache.commons.lang.StringUtils;

public class TextBackground
implements IPaintDelegate {
    private Font textFont;
    private String clientPropKey;
    private Color textColor;

    public TextBackground font(String fontSpec) {
        this.textFont = Font.decode(fontSpec);
        return this;
    }

    public TextBackground clientPropertyKey(String key) {
        this.clientPropKey = key;
        return this;
    }

    public TextBackground textColor(String colorSpec) {
        this.textColor = Color.decode(colorSpec);
        return this;
    }

    @Override
    public void doPaint(Component comp, Graphics g, int x, int y, int width, int height) {
        if (!(comp instanceof JComponent)) {
            return;
        }
        if (StringUtils.isBlank((String)this.clientPropKey)) {
            return;
        }
        JComponent jcomp = (JComponent)comp;
        Object textValue = jcomp.getClientProperty(this.clientPropKey);
        if (textValue == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g.translate(x, y);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Color oldCol = g2.getColor();
        g.setColor(this.textColor);
        Font oldFont = g2.getFont();
        if (this.textFont != null) {
            g.setFont(this.textFont);
        } else {
            g.setFont(jcomp.getFont());
        }
        FontMetrics fonMet = jcomp.getFontMetrics(g.getFont());
        int lineHeight = fonMet.getHeight();
        Insets insets = jcomp.getInsets();
        int adjustment = (jcomp.getHeight() - insets.top - insets.bottom - lineHeight) / 2;
        int ypos = lineHeight + adjustment;
        g.drawString(textValue.toString(), insets.left, ypos);
        g.translate(-x, -y);
        g2.setColor(oldCol);
        g2.setFont(oldFont);
    }
}

