/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.popup;

import in.gov.uidai.swing.popup.ErrorMsgPopup;
import in.gov.uidai.swing.popup.SimpleMsgPopup;
import in.gov.uidai.swing.popup.YesNoInfoMsgPopup;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import javax.swing.JOptionPane;

public class MessagePopup {
    private static final String ERROR_ICON = "uidlaf/images/msg-error.png";
    private static final String WARNING_ICON = "uidlaf/images/msg-warning.png";
    private static final String INFO_ICON = "uidlaf/images/msg-info.png";
    private SimpleMsgPopup simpleMsgPopup;
    private ErrorMsgPopup errorMsgPopup;
    private YesNoInfoMsgPopup yesNoInfoMsgPopup;

    public MessagePopup(Component parent) {
        Frame window = JOptionPane.getFrameForComponent(parent);
        if (window != null) {
            this.simpleMsgPopup = new SimpleMsgPopup(window);
            this.errorMsgPopup = new ErrorMsgPopup(window);
            this.yesNoInfoMsgPopup = new YesNoInfoMsgPopup(window);
        } else if (window instanceof Dialog) {
            this.simpleMsgPopup = new SimpleMsgPopup((Dialog)((Object)window));
            this.errorMsgPopup = new ErrorMsgPopup((Dialog)((Object)window));
            this.yesNoInfoMsgPopup = new YesNoInfoMsgPopup((Dialog)((Object)window));
        } else {
            this.simpleMsgPopup = new SimpleMsgPopup();
            this.errorMsgPopup = new ErrorMsgPopup();
            this.yesNoInfoMsgPopup = new YesNoInfoMsgPopup();
        }
    }

    public void createMessage(String message, String code, String trnx, Image winIcon) {
        this.errorMsgPopup.setMessage(message, code, trnx, winIcon);
        this.errorMsgPopup.setVisible(true);
    }

    public void createWarningMessage(String message, Image winIcon) {
        this.simpleMsgPopup.createMessage(message, WARNING_ICON, winIcon);
        this.simpleMsgPopup.setVisible(true);
    }

    public void createInfoMessage(String message, Image winIcon) {
        this.simpleMsgPopup.createMessage(message, INFO_ICON, winIcon);
        this.simpleMsgPopup.setVisible(true);
    }

    public void createErrorMessage(String message, Image winIcon) {
        this.simpleMsgPopup.createMessage(message, ERROR_ICON, winIcon);
        this.simpleMsgPopup.setVisible(true);
    }

    public void createInfoMessageTest(String message, JOptionPane op) {
        this.yesNoInfoMsgPopup.createMessage(message, INFO_ICON, op);
        this.yesNoInfoMsgPopup.setVisible(true);
    }

    public Object getOpValue() {
        return this.yesNoInfoMsgPopup.getOpValue();
    }
}

