/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.popup;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class SimpleMsgPopup
extends JDialog {
    private JButton btnClose;
    private JLabel messageLabel;
    private JLabel iconLabel;
    private JPanel mainPanel;
    private final Color customBlue = new Color(19, 126, 178);

    public SimpleMsgPopup(Frame parent) {
        super(parent, true);
        this.initComponents();
    }

    public SimpleMsgPopup(Dialog parent) {
        super(parent, true);
        this.initComponents();
    }

    public SimpleMsgPopup() {
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.iconLabel = new JLabel();
        this.messageLabel = new JLabel();
        this.btnClose = new JButton();
        this.messageLabel.setName("ErrorMessageLabel");
        this.setDefaultCloseOperation(2);
        this.setTitle("Universal Client");
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.mainPanel.setBackground(new Color(255, 255, 255));
        this.mainPanel.setPreferredSize(new Dimension(600, 170));
        this.mainPanel.setLayout((LayoutManager)new AbsoluteLayout());
        this.messageLabel.setFont(new Font("Nirmala UI", 1, 14));
        this.messageLabel.setHorizontalTextPosition(10);
        this.mainPanel.add((Component)this.messageLabel, new AbsoluteConstraints(116, 23, 460, 85));
        this.btnClose.setFont(new Font("Nirmala UI", 1, 12));
        this.btnClose.setForeground(this.customBlue);
        this.btnClose.setText("CLOSE");
        this.btnClose.setToolTipText("close");
        this.mainPanel.add((Component)this.btnClose, new AbsoluteConstraints(260, 108, 80, 33));
        this.btnClose.addActionListener(e -> this.dispose());
        this.iconLabel.setMaximumSize(new Dimension(60, 60));
        this.iconLabel.setMinimumSize(new Dimension(60, 60));
        this.mainPanel.add((Component)this.iconLabel, new AbsoluteConstraints(40, 40, -1, -1));
        this.getContentPane().add((Component)this.mainPanel, new AbsoluteConstraints(0, 0, 600, 171));
        this.setPosition();
        this.pack();
    }

    public void createMessage(String message, String icon, Image winIcon) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Image img = new ImageIcon(Objects.requireNonNull(cl.getResource(icon))).getImage();
        this.setIconImage(winIcon);
        this.iconLabel.setIcon(new ImageIcon(img));
        this.messageLabel.setText("<html>" + message + "</html>");
    }

    private void setPosition() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (int)(((double)screenSize.width - this.mainPanel.getPreferredSize().getWidth()) / 2.0);
        int y = (int)(((double)screenSize.height - this.mainPanel.getPreferredSize().getHeight()) / 2.0);
        this.setLocation(x, y);
    }
}

