/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.tilv;

import in.gov.uidai.swing.tilv.FBMaxLengthDocument;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang.StringUtils;

public class FBExcludePatternDocument
extends FBMaxLengthDocument {
    private final List<PatternData> excludePatterns = new ArrayList<PatternData>();
    private final List<PatternData> includePatterns = new ArrayList<PatternData>();

    public FBExcludePatternDocument(JTextField comp, int maxLength) {
        super(comp);
        this.setMaxLength(maxLength);
    }

    public void includePattern(String pat) {
        this.includePattern(pat, null);
    }

    public void includePattern(String pat, String msg) {
        this.includePatterns.add(new PatternData(pat, msg));
    }

    public void excludePattern(String pat) {
        this.excludePattern(pat, null);
    }

    public void excludePattern(String pat, String msg) {
        this.excludePatterns.add(new PatternData(pat, msg));
    }

    public void excludePattern(String[] patterns, String msg) {
        for (String pat : patterns) {
            this.excludePatterns.add(new PatternData(pat, msg));
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        StringBuilder buffer = new StringBuilder(this.getTextInField());
        buffer.insert(offs, str);
        String target = buffer.toString();
        for (PatternData pd : this.includePatterns) {
            if (Pattern.matches(pd.pattern, target)) continue;
            this.showFeedback(StringUtils.isBlank((String)pd.msg) ? "input must match " + pd.pattern : pd.msg);
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        for (PatternData pd : this.excludePatterns) {
            if (!Pattern.matches(pd.pattern, target)) continue;
            this.showFeedback(StringUtils.isBlank((String)pd.msg) ? "input must not match " + pd.pattern : pd.msg);
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.insertString(offs, str, a);
    }

    private static class PatternData {
        String pattern;
        String msg;

        public PatternData(String pattern, String msg) {
            this.pattern = pattern;
            this.msg = msg;
        }
    }
}

