/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.tilv;

import in.gov.uidai.swing.tilv.FeedbackDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public class FBMaxLengthDocument
extends FeedbackDocument {
    private int maxLength;
    private String maxLengthMsg;

    public FBMaxLengthDocument(JTextComponent comp) {
        super(comp);
    }

    public FBMaxLengthDocument(JTextComponent comp, int maxLength) {
        super(comp);
        this.maxLength = maxLength;
    }

    public final void setMaxLength(int length) {
        this.maxLength = length;
    }

    public final void setMaxLength(int length, String msg) {
        this.maxLength = length;
        this.maxLengthMsg = msg;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.maxLength <= 0) {
            super.insertString(offs, str, a);
        } else if (this.getLength() + str.length() <= this.maxLength) {
            super.insertString(offs, str, a);
        } else if (StringUtils.isBlank((String)this.maxLengthMsg)) {
            this.showFeedback("maximum length of " + this.maxLength + " chars exceeded");
        } else {
            this.showFeedback(this.maxLengthMsg);
        }
    }
}

