/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.translit;

import in.gov.uidai.swing.border.DashedBorder;
import in.gov.uidai.swing.fontman.FontManager;
import in.gov.uidai.translit.core.TransliterationManager;
import in.gov.uidai.translit.spi.ITransliterationProvider;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodContext;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Locale;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class IndicIM
implements InputMethod {
    public static final String KEY_TRANSLIT_HINTS = "uid.translit.hint";
    private String localeSpec;
    private Locale locale;
    private ComponentOrientation compOrient;
    private InputMethodContext imCtxt;
    private boolean compositeFlag;
    private StringBuffer composeBuffer = new StringBuffer();
    private ITransliterationProvider tlitProv;
    private JList suggestList;
    private DefaultListModel suggestModel = new DefaultListModel();
    private JScrollPane suggestScroll;
    private Popup popup;

    public IndicIM() {
        this.suggestList = new JList(this.suggestModel);
        this.suggestList.getSelectionModel().setSelectionMode(1);
        this.suggestList.addMouseListener(new ListMouseHandler());
        this.suggestScroll = new JScrollPane(this.suggestList);
        this.suggestScroll.setBorder(new DashedBorder().dashInterval("1.2, 1.2").lineColor("#baba45").lineThickness(1.0f));
        this.suggestList.setBackground(Color.decode("#f5f5b5"));
    }

    @Override
    public void activate() {
        this.composeBuffer = new StringBuffer();
        this.suggestModel.clear();
    }

    @Override
    public void deactivate(boolean temporary) {
        this.composeBuffer = new StringBuffer();
        this.suggestModel.clear();
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    @Override
    public void dispatchEvent(AWTEvent evt) {
        if (this.locale.getLanguage().equalsIgnoreCase("en")) {
            return;
        }
        if (!(evt instanceof KeyEvent)) {
            return;
        }
        KeyEvent kevt = (KeyEvent)evt;
        TransliterationHints[] hints = null;
        if (evt.getSource() instanceof JComponent) {
            hints = (TransliterationHints[])((JComponent)evt.getSource()).getClientProperty(KEY_TRANSLIT_HINTS);
        }
        if (kevt.getID() != 400) {
            int keyCode = kevt.getKeyCode();
            switch (keyCode) {
                case 33: 
                case 34: 
                case 38: 
                case 40: {
                    if (this.popup == null) break;
                    this.suggestList.dispatchEvent(kevt);
                }
            }
            return;
        }
        char kchar = kevt.getKeyChar();
        int type = Character.getType(kchar);
        if (type == 21 || type == 22 || type == 12) {
            String itext = (String)this.suggestList.getSelectedValue();
            if (itext == null || itext.trim().length() == 0) {
                itext = this.tlitProv.transliterate(this.composeBuffer.toString(), this.localeSpec, hints);
            }
            if (itext != null) {
                this.applyTrans(itext);
            }
            return;
        }
        switch (kchar) {
            case '\u001b': {
                if (this.popup != null) {
                    this.popup.hide();
                    this.popup = null;
                }
                return;
            }
            case '\n': {
                String suggest;
                if (this.popup != null && (suggest = (String)this.suggestList.getSelectedValue()) != null) {
                    this.applyTrans(suggest);
                }
                return;
            }
            case '\b': {
                if (this.composeBuffer.length() <= 0) break;
                int pos = this.composeBuffer.length() - 1;
                this.composeBuffer.deleteCharAt(pos);
                break;
            }
            case '\u007f': {
                AttributedCharacterIterator aci;
                int index;
                if (this.composeBuffer.length() <= 0 || (index = (aci = this.imCtxt.getCommittedText(0, this.imCtxt.getCommittedTextLength(), null)).getIndex()) >= this.composeBuffer.length() - 1) break;
                this.composeBuffer.deleteCharAt(index);
                break;
            }
            default: {
                if (kevt.getModifiers() != 0) break;
                this.composeBuffer.append(kchar);
            }
        }
        if (this.composeBuffer.length() > 0) {
            AttributedString astr = new AttributedString(this.composeBuffer.toString());
            astr.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT);
            this.imCtxt.dispatchInputMethodEvent(1100, astr.getIterator(), 0, TextHitInfo.afterOffset(this.composeBuffer.length()), null);
            this.showPopup(hints);
            kevt.consume();
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void endComposition() {
        this.composeBuffer = new StringBuffer();
        AttributedString astr = new AttributedString(this.composeBuffer.toString());
        this.imCtxt.dispatchInputMethodEvent(1100, astr.getIterator(), 0, TextHitInfo.afterOffset(this.composeBuffer.length()), null);
    }

    @Override
    public Object getControlObject() {
        return null;
    }

    @Override
    public void hideWindows() {
    }

    @Override
    public void notifyClientWindowChange(Rectangle rect) {
    }

    @Override
    public void reconvert() {
    }

    @Override
    public void removeNotify() {
    }

    @Override
    public void setCharacterSubsets(Character.Subset[] arg0) {
    }

    @Override
    public boolean isCompositionEnabled() {
        return this.compositeFlag;
    }

    @Override
    public void setCompositionEnabled(boolean flag) {
        this.compositeFlag = flag;
    }

    @Override
    public void setInputMethodContext(InputMethodContext ctxt) {
        this.imCtxt = ctxt;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean setLocale(Locale locale) {
        Font font;
        this.localeSpec = locale.getLanguage() + "_" + locale.getCountry();
        this.localeSpec = this.localeSpec.toLowerCase();
        this.locale = locale;
        this.compOrient = ComponentOrientation.getOrientation(locale);
        this.composeBuffer = new StringBuffer();
        this.tlitProv = TransliterationManager.getInst().getTransliterationProvider(this.localeSpec);
        Font suggestFont = FontManager.getInst().getScreenFontForLocale(this.localeSpec);
        if (this.tlitProv != null && (font = this.tlitProv.getFontForLocale(this.localeSpec, suggestFont.getSize())) != null) {
            suggestFont = font;
        }
        if (suggestFont != null) {
            this.suggestList.setFont(suggestFont);
        }
        return true;
    }

    private void showPopup(TransliterationHints[] hints) {
        int length;
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        String[] suggestions = hints != null ? this.tlitProv.suggest(this.composeBuffer.toString(), this.localeSpec, hints) : new String[]{};
        int n = length = suggestions != null ? suggestions.length : 0;
        if (length > 5) {
            length = 5;
        }
        this.suggestModel.clear();
        for (int i = 0; i < length; ++i) {
            this.suggestModel.addElement(suggestions[i]);
        }
        this.suggestList.setVisibleRowCount(length);
        Rectangle textPos = this.imCtxt.getTextLocation(TextHitInfo.beforeOffset(0));
        int popx = textPos.x;
        int popy = textPos.y + textPos.height;
        this.popup = PopupFactory.getSharedInstance().getPopup(null, this.suggestScroll, popx, popy);
        this.popup.show();
    }

    private void applyTrans(String itext) {
        AttributedString astr = new AttributedString(itext);
        TextHitInfo caret = null;
        caret = this.compOrient == null || this.compOrient.isLeftToRight() ? null : TextHitInfo.beforeOffset(-itext.length());
        TextHitInfo visPos = null;
        visPos = this.compOrient == null || this.compOrient.isLeftToRight() ? null : TextHitInfo.beforeOffset(-itext.length());
        this.imCtxt.dispatchInputMethodEvent(1100, astr.getIterator(), itext.length(), caret, visPos);
        this.composeBuffer = new StringBuffer();
        this.suggestModel.clear();
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    private class ListMouseHandler
    extends MouseAdapter {
        private ListMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            String suggest;
            if (IndicIM.this.popup != null && (suggest = (String)IndicIM.this.suggestList.getSelectedValue()) != null) {
                IndicIM.this.applyTrans(suggest);
            }
        }
    }
}

