/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.translit;

import in.gov.uidai.ec.icas.text.UidLocaleUtils;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.swing.fontman.FontManager;
import in.gov.uidai.swing.translit.AbstractIMTranslitField;
import in.gov.uidai.swing.translit.NativeXIMTextField;
import in.gov.uidai.swing.translit.XIMTranslitField;
import in.gov.uidai.translit.core.TransliterationManager;
import in.gov.uidai.translit.events.ISoftKeyboardListener;
import in.gov.uidai.translit.events.SoftKeyStroke;
import in.gov.uidai.translit.spi.ISoftKeyboard;
import in.gov.uidai.translit.spi.ISoftKeyboardProvider;
import in.gov.uidai.translit.spi.ITransliterationProvider;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeXIMTranslitField
extends AbstractIMTranslitField {
    private static final Logger LOGGER = LoggerFactory.getLogger(XIMTranslitField.class);
    private NativeXIMTextField awtPeer = new NativeXIMTextField(this);
    private JTextField srcTextField;
    private ITransliterationProvider tlitProv;
    private TransliterationHints[] hints;
    private String localeSpec;
    private Locale locale;

    public NativeXIMTranslitField() {
        this.getInputMap().put(KeyStroke.getKeyStroke("INSERT"), "tlit");
        this.getActionMap().put("tlit", new TransliterateAction());
        this.getInputMap().put(KeyStroke.getKeyStroke("control K"), "kbd");
        this.getActionMap().put("kbd", new KeyboardAction());
        this.addFocusListener(new FocusHandler());
    }

    public void setTransliterationHints(TransliterationHints ... hints) {
        this.hints = hints;
        this.putClientProperty("uid.translit.hint", hints);
    }

    @Override
    public void associate(JTextField source) {
        this.srcTextField = source;
    }

    @Override
    public void setEnrollmentService(EnrollmentService enrollmentService) {
    }

    @Override
    public void setLocale(String localeStr) {
        Font font;
        this.localeSpec = localeStr.toLowerCase();
        this.locale = UidLocaleUtils.parseLocaleStr((String)(localeStr + "_UID"));
        Font fieldFont = FontManager.getInst().getScreenFontForLocale(this.localeSpec);
        this.tlitProv = TransliterationManager.getInst().getTransliterationProvider(this.localeSpec);
        if (this.tlitProv != null && (font = this.tlitProv.getFontForLocale(this.localeSpec, fieldFont.getSize())) != null) {
            fieldFont = font;
            LOGGER.debug("provider font " + fieldFont);
        }
        LOGGER.debug("final field font is " + fieldFont);
        if (fieldFont != null) {
            this.setFont(fieldFont);
            this.awtPeer.setFont(fieldFont);
        }
    }

    @Override
    public void setTextDirect(String text) {
        super.setText(text);
        this.awtPeer.setText(text);
        this.awtPeer.repaint();
    }

    @Override
    public void tuneTransliteration() {
    }

    @Override
    public void setText(String text) {
        if (!this.isFocusable()) {
            super.setText(text);
            return;
        }
        try {
            super.setText(this.tlitProv.transliterate(text, this.localeSpec, this.hints));
        }
        catch (Exception e) {
            super.setText(text);
            LOGGER.warn("transliteration failed", (Throwable)e);
        }
    }

    @Override
    public void setBorder(Border b) {
    }

    @Override
    public void paintComponent(Graphics g) {
    }

    @Override
    public void paintChildren(Graphics g) {
    }

    void fireKeyEvent(KeyEvent evt) {
        this.processKeyEvent(evt);
    }

    ITransliterationProvider getProvider() {
        return this.tlitProv;
    }

    String getLocaleSpec() {
        return this.localeSpec;
    }

    private void showSoftKeyboard() {
        ISoftKeyboardProvider provider = TransliterationManager.getInst().getSoftKeyboardProvider();
        if (provider != null) {
            ISoftKeyboard kbd = provider.getSoftKeyboard(this.localeSpec);
            kbd.addListener((ISoftKeyboardListener)new SoftKeyHandler());
            JPopupMenu popup = new JPopupMenu();
            popup.add(kbd.getRenderer());
            popup.show(this, 0, this.getHeight());
        }
    }

    private class SoftKeyHandler
    implements ISoftKeyboardListener {
        private SoftKeyHandler() {
        }

        public void keyTyped(SoftKeyStroke ks) {
            if (ks.getKeyCode() == 0) {
                char[] dispChars;
                for (char key : dispChars = ks.getDisplayChars()) {
                    KeyEvent evt = new KeyEvent(NativeXIMTranslitField.this, 400, System.currentTimeMillis(), 0, 0, key);
                    NativeXIMTranslitField.this.processKeyEvent(evt);
                }
            } else {
                KeyEvent evt = new KeyEvent(NativeXIMTranslitField.this, 401, System.currentTimeMillis(), ks.getModifiers(), ks.getKeyCode(), '\uffff');
                NativeXIMTranslitField.this.processKeyEvent(evt);
            }
        }
    }

    private class KeyboardAction
    extends AbstractAction {
        private KeyboardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NativeXIMTranslitField.this.showSoftKeyboard();
        }
    }

    private class TransliterateAction
    extends AbstractAction {
        private TransliterateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (NativeXIMTranslitField.this.srcTextField != null && StringUtils.isNotBlank((String)NativeXIMTranslitField.this.srcTextField.getText())) {
                NativeXIMTranslitField.this.setText(NativeXIMTranslitField.this.srcTextField.getText().toLowerCase());
            }
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            InputContext ipCtxt = NativeXIMTranslitField.this.getInputContext();
            if (ipCtxt == null) {
                return;
            }
            try {
                ipCtxt.setCompositionEnabled(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ipCtxt.selectInputMethod(NativeXIMTranslitField.this.locale);
            if (NativeXIMTranslitField.this.getText().trim().length() == 0 && NativeXIMTranslitField.this.srcTextField != null && StringUtils.isNotBlank((String)NativeXIMTranslitField.this.srcTextField.getText())) {
                NativeXIMTranslitField.this.setText(NativeXIMTranslitField.this.srcTextField.getText().toLowerCase());
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            InputContext ipCtxt = NativeXIMTranslitField.this.getInputContext();
            if (ipCtxt == null) {
                return;
            }
            if (!ipCtxt.selectInputMethod(Locale.getDefault())) {
                ipCtxt.selectInputMethod(new Locale("EN", "US"));
            }
        }
    }
}

