/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.translit;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.swing.fontman.FontManager;
import in.gov.uidai.swing.translit.AbstractIMTranslitField;
import java.awt.AWTException;
import java.awt.Font;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.im.InputContext;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class SIMTranslitField
extends AbstractIMTranslitField {
    private JTextField srcTextField;
    private Locale tlitLocale;

    public SIMTranslitField() {
        this.getInputMap().put(KeyStroke.getKeyStroke("INSERT"), "tlit");
        this.getActionMap().put("tlit", new TransliterateAction());
        this.addFocusListener(new FocusHandler());
    }

    @Override
    public void setEnrollmentService(EnrollmentService enrollmentService) {
    }

    @Override
    public void associate(JTextField source) {
        this.srcTextField = source;
    }

    @Override
    public void setLocale(String code) {
        String[] parts = code.split("_");
        this.tlitLocale = parts.length == 1 ? new Locale(parts[0]) : (parts.length == 2 ? new Locale(parts[0], parts[1]) : new Locale(parts[0], parts[1], parts[2]));
        Font font = FontManager.getInst().getScreenFontForLocale(code);
        if (font != null) {
            this.setFont(font);
        }
    }

    @Override
    public void tuneTransliteration() {
    }

    @Override
    public void setText(String text) {
        if (!this.isFocusable()) {
            super.setText(text);
            return;
        }
        this.grabFocus();
        super.setText("");
        Robot robot = null;
        try {
            robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        if (robot == null) {
            super.setText(text);
            return;
        }
        String srcText = text.toUpperCase();
        this.grabFocus();
        for (int i = 0; i < srcText.length(); ++i) {
            robot.keyPress(srcText.charAt(i));
            robot.keyRelease(srcText.charAt(i));
        }
        robot.keyPress(10);
        robot.keyRelease(10);
    }

    private class TransliterateAction
    extends AbstractAction {
        private TransliterateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SIMTranslitField.this.srcTextField != null) {
                SIMTranslitField.this.setText(SIMTranslitField.this.srcTextField.getText());
            }
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            InputContext ipCtxt = SIMTranslitField.this.getInputContext();
            if (ipCtxt == null) {
                return;
            }
            if (SIMTranslitField.this.tlitLocale != null) {
                ipCtxt.selectInputMethod(SIMTranslitField.this.tlitLocale);
            }
            if (SIMTranslitField.this.getText().trim().length() == 0 && SIMTranslitField.this.srcTextField != null) {
                SIMTranslitField.this.setText(SIMTranslitField.this.srcTextField.getText());
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            InputContext ipCtxt = SIMTranslitField.this.getInputContext();
            if (ipCtxt == null) {
                return;
            }
            if (!ipCtxt.selectInputMethod(Locale.getDefault())) {
                ipCtxt.selectInputMethod(new Locale("EN", "US"));
            }
        }
    }
}

