/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.translit;

import in.gov.uidai.ime.IIndicIMFactory;
import in.gov.uidai.ime.IndicIMDescriptor;
import in.gov.uidai.swing.translit.IMType;
import in.gov.uidai.swing.translit.IndicIM;
import in.gov.uidai.translit.core.TransliterationManager;
import in.gov.uidai.translit.spi.IEditDistance;
import in.gov.uidai.translit.spi.ISoftKeyboardProvider;
import in.gov.uidai.translit.spi.ITransliterationProvider;
import java.awt.im.spi.InputMethod;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransliterationSetup {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransliterationSetup.class);
    public static final String TRANSLIT_PROVIDERS = "res/cui/transliteration.providers";
    public static final String SOFT_KBD_PROVIDER = "res/cui/soft-keyboard.provider";
    public static final String EDIT_DIST_PROVIDER = "res/cui/edit-distance.providers";

    public void loadAll() {
        try {
            this.loadTransliterationProviders();
        }
        catch (IOException exep) {
            LOGGER.error("unable to load list of transliteration providers");
        }
        try {
            this.loadKeyboardProvider();
        }
        catch (IOException exep) {
            LOGGER.error("unable to load keyboard provider information");
        }
        catch (ClassNotFoundException exep) {
            LOGGER.error("keyboard provider class not found: " + exep.getMessage());
        }
        catch (IllegalAccessException exep) {
            LOGGER.error("keyboard provider class is not accessible: " + exep.getMessage());
        }
        catch (InstantiationException exep) {
            LOGGER.error("keyboard provider class cannot be instantiated: " + exep.getMessage());
        }
        try {
            this.loadEditDistance();
        }
        catch (IOException exep) {
            LOGGER.error("unable to load list of edit distance providers");
        }
    }

    public IMType getIMType() {
        String imTypeStr = System.getProperty("imType", "swing");
        if (StringUtils.equalsIgnoreCase((String)imTypeStr, (String)"system")) {
            return IMType.SYSTEM;
        }
        if (StringUtils.equalsIgnoreCase((String)imTypeStr, (String)"swing")) {
            return IMType.SWING;
        }
        if (StringUtils.equalsIgnoreCase((String)imTypeStr, (String)"awt")) {
            return IMType.AWT;
        }
        return IMType.SWING;
    }

    public void shutdown() {
        IndicIMDescriptor.setFactory(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTransliterationProviders() throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try (InputStream input = null;){
            String oneLine;
            input = cl.getResourceAsStream(TRANSLIT_PROVIDERS);
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((oneLine = StringUtils.strip((String)reader.readLine())) != null) {
                if (StringUtils.isBlank((String)oneLine) || StringUtils.startsWith((String)oneLine, (String)"#")) continue;
                try {
                    ITransliterationProvider tp = (ITransliterationProvider)Class.forName(oneLine).newInstance();
                    TransliterationManager.getInst().register(tp);
                }
                catch (NoClassDefFoundError error) {
                    if (!LOGGER.isErrorEnabled()) continue;
                    LOGGER.error("class not found: " + error.getMessage());
                }
                catch (ClassNotFoundException exep) {
                    if (!LOGGER.isErrorEnabled()) continue;
                    LOGGER.error("transliteration provider class not found: " + oneLine, (Throwable)exep);
                }
                catch (IllegalAccessException exep) {
                    if (!LOGGER.isErrorEnabled()) continue;
                    LOGGER.error("transliteration provider class is not accessible: " + oneLine);
                }
                catch (InstantiationException exep) {
                    if (!LOGGER.isErrorEnabled()) continue;
                    LOGGER.error("transliteration provider class cannot be instantiated: " + oneLine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeyboardProvider() throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try (InputStream input = null;){
            input = cl.getResourceAsStream(SOFT_KBD_PROVIDER);
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            String oneLine = StringUtils.strip((String)reader.readLine());
            if (StringUtils.isBlank((String)oneLine) || oneLine.startsWith("#")) {
                return;
            }
            ISoftKeyboardProvider kbp = (ISoftKeyboardProvider)Class.forName(oneLine).newInstance();
            TransliterationManager.getInst().register(kbp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEditDistance() throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try (InputStream input = null;){
            String oneLine;
            input = cl.getResourceAsStream(EDIT_DIST_PROVIDER);
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((oneLine = StringUtils.strip((String)reader.readLine())) != null) {
                if (StringUtils.isBlank((String)oneLine) || StringUtils.startsWith((String)oneLine, (String)"#")) continue;
                try {
                    IEditDistance ed = (IEditDistance)Class.forName(oneLine).newInstance();
                    TransliterationManager.getInst().register(ed);
                }
                catch (ClassNotFoundException exep) {
                    if (!LOGGER.isErrorEnabled()) continue;
                    LOGGER.error("edit distance class not found: " + oneLine);
                }
                catch (IllegalAccessException exep) {
                    if (!LOGGER.isErrorEnabled()) continue;
                    LOGGER.error("edit distance class is not accessible: " + oneLine);
                }
                catch (InstantiationException exep) {
                    if (!LOGGER.isErrorEnabled()) continue;
                    LOGGER.error("edit distance class cannot be instantiated: " + oneLine);
                }
            }
        }
    }

    static {
        IndicIMDescriptor.setFactory((IIndicIMFactory)new IndicIMFactory());
    }

    private static class IndicIMFactory
    implements IIndicIMFactory {
        private IndicIMFactory() {
        }

        public InputMethod createInputMethod() {
            return new IndicIM();
        }
    }
}

