/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.translit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import in.gov.uidai.ec.ecmpapi.ProxyConfiguration;
import in.gov.uidai.ec.icas.text.UidLocaleUtils;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrollmentState;
import in.gov.uidai.ec.service.findaadhaar.model.BitIdentifierSelection;
import in.gov.uidai.swing.fontman.FontManager;
import in.gov.uidai.swing.translit.AbstractIMTranslitField;
import in.gov.uidai.translit.core.TransliterationManager;
import in.gov.uidai.translit.events.ISoftKeyboardListener;
import in.gov.uidai.translit.events.SoftKeyStroke;
import in.gov.uidai.translit.spi.ISoftKeyboard;
import in.gov.uidai.translit.spi.ISoftKeyboardProvider;
import in.gov.uidai.translit.spi.ITransliterationProvider;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultStyledDocument;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XIMTranslitField
extends AbstractIMTranslitField {
    private static final Logger LOGGER = LoggerFactory.getLogger(XIMTranslitField.class);
    private JTextField srcTextField;
    private ITransliterationProvider tlitProv;
    private TransliterationHints[] hints;
    private String localeSpec;
    private Locale locale;
    protected EnrollmentService enrollmentService;
    private EnrollmentState enrollmentState;

    public EnrollmentService getEnrollmentService() {
        return this.enrollmentService;
    }

    public XIMTranslitField() {
        this.getInputMap().put(KeyStroke.getKeyStroke("INSERT"), "tlit");
        this.getActionMap().put("tlit", new TransliterateAction());
        this.getInputMap().put(KeyStroke.getKeyStroke("control K"), "kbd");
        this.getActionMap().put("kbd", new KeyboardAction());
        this.addFocusListener(new FocusHandler());
        this.setDocument(new DefaultStyledDocument());
    }

    public void setTransliterationHints(TransliterationHints ... hints) {
        this.hints = hints;
        this.putClientProperty("uid.translit.hint", hints);
    }

    @Override
    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    @Override
    public void associate(JTextField source) {
        this.srcTextField = source;
        this.srcTextField.addFocusListener(new ReverseFocusHandler());
    }

    @Override
    public void setLocale(String localeStr) {
        Font font;
        this.localeSpec = localeStr.toLowerCase();
        this.locale = UidLocaleUtils.parseLocaleStr((String)(localeStr + "_UID"));
        ComponentOrientation co = ComponentOrientation.getOrientation(this.locale);
        this.setComponentOrientation(co);
        Font fieldFont = FontManager.getInst().getScreenFontForLocale(this.localeSpec);
        this.tlitProv = TransliterationManager.getInst().getTransliterationProvider(this.localeSpec);
        if (this.tlitProv != null && (font = this.tlitProv.getFontForLocale(this.localeSpec, fieldFont.getSize())) != null) {
            fieldFont = font;
            LOGGER.debug("provider font " + fieldFont);
        }
        LOGGER.debug("final field font is " + fieldFont);
        if (fieldFont != null) {
            this.setFont(fieldFont);
        }
    }

    @Override
    public void tuneTransliteration() {
        if (this.srcTextField == null) {
            return;
        }
        String srcText = this.stripDoubleSpaces(this.srcTextField.getText());
        if (StringUtils.isBlank((String)srcText)) {
            return;
        }
        String ownText = this.stripDoubleSpaces(this.getText());
        if (StringUtils.equalsIgnoreCase((String)ownText, (String)this.tlitProv.transliterate(srcText, this.localeSpec, this.hints).trim())) {
            return;
        }
        if (StringUtils.countMatches((String)ownText, (String)" ") == StringUtils.countMatches((String)srcText, (String)" ")) {
            try {
                this.tlitProv.tuneEnglishToIndic(srcText, ownText, this.localeSpec, new TransliterationHints[0]);
            }
            catch (Exception e) {
                LOGGER.warn("Exception happened while translit tuning:");
            }
        } else {
            LOGGER.warn("Word count mismatch: Cannot tune from English");
        }
    }

    @Override
    public synchronized void setText(String text) {
        if (!this.isFocusable() || this.tlitProv == null) {
            super.setText(text);
            return;
        }
        try {
            Charset charset = Charset.forName("UTF-8");
            if (!text.isEmpty() && this.enrollmentService != null) {
                super.setText(charset.decode(charset.encode(this.makeOnlineBashiniApiCall(text, this.localeSpec).trim())).toString());
            } else if (text.isEmpty() && this.enrollmentService != null) {
                super.setText(this.tlitProv.transliterate(text, this.localeSpec, this.hints).trim());
            }
        }
        catch (Exception e) {
            LOGGER.warn("transliteration failed", (Throwable)e);
        }
    }

    void fireKeyEvent(KeyEvent evt) {
        this.processKeyEvent(evt);
    }

    ITransliterationProvider getProvider() {
        return this.tlitProv;
    }

    String getLocaleSpec() {
        return this.localeSpec;
    }

    private String stripDoubleSpaces(String input) {
        String ret = input;
        while (ret.contains("  ")) {
            ret = ret.replace("  ", " ");
        }
        return ret;
    }

    private void showSoftKeyboard() {
        ISoftKeyboardProvider provider = TransliterationManager.getInst().getSoftKeyboardProvider();
        if (provider == null) {
            return;
        }
        ISoftKeyboard kbd = provider.getSoftKeyboard(this.localeSpec);
        kbd.addListener((ISoftKeyboardListener)new SoftKeyHandler());
        JPopupMenu popup = new JPopupMenu();
        popup.add(kbd.getRenderer());
        popup.show(this, 0, this.getHeight());
    }

    public String makeOnlineBashiniApiCall(String engText, String localeSpec) throws IOException {
        String output = "";
        try {
            String responseString;
            ObjectMapper mapper = new ObjectMapper();
            String bashiniLocaleSpec = localeSpec.substring(0, 2);
            ObjectNode data = mapper.createObjectNode();
            ObjectNode objPipelineTask = mapper.createObjectNode();
            ArrayNode arrPipelineTasks = mapper.createArrayNode();
            ObjectNode language = mapper.createObjectNode();
            ObjectNode languageValues = mapper.createObjectNode();
            languageValues.put("sourceLanguage", "en");
            languageValues.put("targetLanguage", bashiniLocaleSpec);
            language.put("language", (JsonNode)languageValues);
            language.put("serviceId", "ai4bharat/indicxlit--cpu-fsv2");
            language.put("isSentence", Boolean.TRUE);
            language.put("numSuggestions", 1);
            data.put("taskType", "transliteration");
            data.put("config", (JsonNode)language);
            arrPipelineTasks.add((JsonNode)data);
            ObjectNode inputData = mapper.createObjectNode();
            ArrayNode arrInput = mapper.createArrayNode();
            ObjectNode input = mapper.createObjectNode();
            ObjectNode inputValues = mapper.createObjectNode();
            inputValues.put("source", engText);
            arrInput.add((JsonNode)inputValues);
            inputData.put("input", (JsonNode)arrInput);
            objPipelineTask.put("inputData", (JsonNode)inputData);
            objPipelineTask.put("pipelineTasks", (JsonNode)arrPipelineTasks);
            String jsonRequest = new ObjectMapper().writeValueAsString((Object)objPipelineTask);
            BasicHttpParams httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)1000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)1000);
            DefaultHttpClient client = new DefaultHttpClient((HttpParams)httpParams);
            ProxyConfiguration.initialize((DefaultHttpClient)client);
            HttpPost httpRequest = new HttpPost(this.enrollmentService.getOauthGwApiService().getGatewayPreference().getBhashiniUrl());
            httpRequest.addHeader("Accept", "*/*");
            httpRequest.addHeader("User-Agent", "Thunder Client (https://www.thunderclient.com)");
            httpRequest.addHeader("Authorization", this.enrollmentService.getOauthGwApiService().getGatewayPreference().getBhashiniKey());
            httpRequest.setEntity((HttpEntity)new StringEntity(jsonRequest, "application/json", StandardCharsets.UTF_8.displayName()));
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpRequest);
            LOGGER.info("Bashini API call");
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                response.getEntity().writeTo((OutputStream)out);
                responseString = out.toString();
            }
            JsonNode convertedJsonResponse = (JsonNode)mapper.readValue(responseString, JsonNode.class);
            JsonNode arrPipelineResponse = convertedJsonResponse.get("pipelineResponse");
            JsonNode pipelineObject = arrPipelineResponse.get(0);
            JsonNode arrOutput = pipelineObject.get("output");
            JsonNode outputObject = arrOutput.get(0);
            JsonNode arrTarget = outputObject.get("target");
            JsonNode targetObject = arrTarget.get(0);
            output = targetObject.asText();
            this.setUpdatedBit(true, BitIdentifierSelection.BHASINIUPDATEBIT.getBitIndentifier());
        }
        catch (Exception e) {
            LOGGER.info("Inside catch CDAC translate call");
            output = this.tlitProv.transliterate(engText, localeSpec, this.hints).trim();
        }
        return output;
    }

    protected void setUpdatedBit(boolean updated, int i) {
        StringBuilder updatedBit = new StringBuilder(updated ? "1" : "0");
        StringBuilder updatedBitValues = this.enrollmentService.getUpdatedBitValues();
        updatedBitValues = new StringBuilder(updatedBitValues.substring(0, i) + updatedBit + updatedBitValues.substring(i + 1));
        this.enrollmentService.setUpdatedBitValues(updatedBitValues);
    }

    private class SoftKeyHandler
    implements ISoftKeyboardListener {
        private SoftKeyHandler() {
        }

        public void keyTyped(SoftKeyStroke ks) {
            if (ks.getKeyCode() == 0) {
                char[] dispChars = ks.getDisplayChars();
                if (dispChars != null) {
                    for (char key : dispChars) {
                        KeyEvent evt = new KeyEvent(XIMTranslitField.this, 400, System.currentTimeMillis(), 0, 0, key);
                        XIMTranslitField.this.processKeyEvent(evt);
                    }
                }
            } else {
                KeyEvent evt = new KeyEvent(XIMTranslitField.this, 401, System.currentTimeMillis(), ks.getModifiers(), ks.getKeyCode(), '\uffff');
                XIMTranslitField.this.processKeyEvent(evt);
            }
        }
    }

    private class KeyboardAction
    extends AbstractAction {
        private KeyboardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            XIMTranslitField.this.showSoftKeyboard();
        }
    }

    private class TransliterateAction
    extends AbstractAction {
        private TransliterateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (XIMTranslitField.this.srcTextField != null && StringUtils.isNotBlank((String)XIMTranslitField.this.srcTextField.getText())) {
                XIMTranslitField.this.setText(XIMTranslitField.this.srcTextField.getText());
            }
        }
    }

    private class ReverseFocusHandler
    implements FocusListener {
        private ReverseFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            if (XIMTranslitField.this.srcTextField == null) {
                return;
            }
            if (XIMTranslitField.this.srcTextField.getText().trim().length() > 0) {
                return;
            }
            if (XIMTranslitField.this.getText().trim().length() == 0) {
                return;
            }
            TransliterationManager tlitMgr = TransliterationManager.getInst();
            if (tlitMgr == null) {
                return;
            }
            ITransliterationProvider tlitProv = tlitMgr.getReverseTransliterationProvider(XIMTranslitField.this.localeSpec);
            if (tlitProv == null) {
                return;
            }
            try {
                String rText = tlitProv.rtransliterate(XIMTranslitField.this.getText(), XIMTranslitField.this.localeSpec, XIMTranslitField.this.hints);
                XIMTranslitField.this.srcTextField.setText(rText);
            }
            catch (Exception e) {
                LOGGER.warn("reverse transliteration error", (Throwable)e);
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            InputContext ipCtxt = XIMTranslitField.this.getInputContext();
            if (ipCtxt == null) {
                return;
            }
            try {
                ipCtxt.setCompositionEnabled(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ipCtxt.selectInputMethod(XIMTranslitField.this.locale);
            if (XIMTranslitField.this.getText().trim().length() == 0 && XIMTranslitField.this.srcTextField != null && StringUtils.isNotBlank((String)XIMTranslitField.this.srcTextField.getText())) {
                XIMTranslitField.this.setText(XIMTranslitField.this.srcTextField.getText());
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            InputContext ipCtxt = XIMTranslitField.this.getInputContext();
            if (ipCtxt == null) {
                return;
            }
            ipCtxt.endComposition();
            if (!ipCtxt.selectInputMethod(Locale.getDefault())) {
                ipCtxt.selectInputMethod(new Locale("EN", "US"));
            }
        }
    }
}

