/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.util;

import java.awt.EventQueue;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.stream.IntStream;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang.StringUtils;

public class AutoSearchHandler {
    private JComboBox comboBox;
    private JTextField textField;
    private boolean hidePopup = false;
    private ComboBoxModel model;
    private boolean deletingText;

    public AutoSearchHandler(JComboBox combo) {
        this.setField(combo);
    }

    private void setField(JComboBox comboBox) {
        this.comboBox = comboBox;
        comboBox.setEditable(true);
        this.model = comboBox.getModel();
        this.textField = (JTextField)comboBox.getEditor().getEditorComponent();
        this.textField.addKeyListener(new KeyHandler());
        this.textField.addFocusListener(new FocusHandler());
        this.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    private void setSelectedItem() {
        String text = this.textField.getText();
        ComboBoxModel tempModel = this.getSuggestedModel(text);
        if (tempModel.getSize() == 0) {
            return;
        }
        if (tempModel.getSize() > 0) {
            this.comboBox.setSelectedItem(tempModel.getElementAt(this.getIndexOf(text, tempModel)));
        }
        this.comboBox.setPopupVisible(false);
    }

    private int getIndexOf(String text, ComboBoxModel model) {
        return IntStream.range(0, model.getSize()).parallel().filter(i -> text.equalsIgnoreCase(model.getElementAt(i).toString())).findFirst().orElse(0);
    }

    private void setSuggestionModel(JComboBox comboBox, ComboBoxModel mdl, String str) {
        comboBox.setModel(mdl);
        comboBox.setSelectedIndex(-1);
        ((JTextField)comboBox.getEditor().getEditorComponent()).setText(str);
    }

    private ComboBoxModel getSuggestedModel(String text) {
        DefaultComboBoxModel tempmodel = new DefaultComboBoxModel();
        IntStream.range(0, this.model.getSize()).mapToObj(i -> this.model.getElementAt(i)).filter(value -> StringUtils.startsWithIgnoreCase((String)value.toString(), (String)text)).forEach(tempmodel::addElement);
        return tempmodel;
    }

    class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        @Override
        public void focusLost(FocusEvent fe) {
            if (AutoSearchHandler.this.textField.getText().length() == 0 && AutoSearchHandler.this.comboBox.getItemCount() > 0) {
                AutoSearchHandler.this.comboBox.setSelectedIndex(0);
                return;
            }
            AutoSearchHandler.this.setSelectedItem();
        }

        @Override
        public void focusGained(FocusEvent fe) {
            AutoSearchHandler.this.textField.selectAll();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            EventQueue.invokeLater(() -> {
                String text = AutoSearchHandler.this.textField.getText();
                if (text.length() == 0) {
                    AutoSearchHandler.this.setSuggestionModel(AutoSearchHandler.this.comboBox, AutoSearchHandler.this.model, "");
                    AutoSearchHandler.this.comboBox.setPopupVisible(false);
                    return;
                }
                ComboBoxModel tempModel = AutoSearchHandler.this.getSuggestedModel(text);
                if (tempModel.getSize() == 0 || AutoSearchHandler.this.hidePopup) {
                    AutoSearchHandler.this.comboBox.setPopupVisible(false);
                } else {
                    AutoSearchHandler.this.setSuggestionModel(AutoSearchHandler.this.comboBox, tempModel, text);
                    if (AutoSearchHandler.this.comboBox.isDisplayable()) {
                        AutoSearchHandler.this.comboBox.setPopupVisible(true);
                    }
                }
                if (!AutoSearchHandler.this.deletingText && tempModel.getSize() == 0) {
                    AutoSearchHandler.this.textField.setText(text.length() <= 1 ? "" : text.substring(0, text.length() - 1));
                    UIManager.getLookAndFeel().provideErrorFeedback(AutoSearchHandler.this.comboBox);
                }
            });
        }

        @Override
        public void keyPressed(KeyEvent e) {
            AutoSearchHandler.this.hidePopup = false;
            AutoSearchHandler.this.deletingText = false;
            switch (e.getKeyCode()) {
                case 10: {
                    AutoSearchHandler.this.hidePopup = true;
                    AutoSearchHandler.this.setSelectedItem();
                    break;
                }
                case 27: {
                    AutoSearchHandler.this.hidePopup = true;
                    break;
                }
                case 8: 
                case 127: {
                    AutoSearchHandler.this.deletingText = true;
                }
            }
        }
    }
}

