/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.escapi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import in.gov.uidai.ec.escapi.ChargesInfo;
import in.gov.uidai.ec.escapi.ChecksumInfo;
import in.gov.uidai.ec.escapi.CompleteDeRegistrationException;
import in.gov.uidai.ec.escapi.EnrolServiceClientApiError;
import in.gov.uidai.ec.escapi.EnrolServiceClientApiException;
import in.gov.uidai.ec.escapi.EnrolmentInfo;
import in.gov.uidai.ec.escapi.FetchOperatorDetailException;
import in.gov.uidai.ec.escapi.FetchRegistrationException;
import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.LocalisationInfo;
import in.gov.uidai.ec.escapi.OperatorInfo;
import in.gov.uidai.ec.escapi.PingResponse;
import in.gov.uidai.ec.escapi.PrintAadharInfo;
import in.gov.uidai.ec.escapi.RegistrationInfo;
import in.gov.uidai.ec.escapi.ScannerInfo;
import in.gov.uidai.ec.escapi.StartDeRegistrationException;
import in.gov.uidai.ec.escapi.StationInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.escapi.StationSettingsInfo;
import in.gov.uidai.ec.escapi.StoreOperatorDetailException;
import in.gov.uidai.ec.escapi.StoreRegistrationException;
import in.gov.uidai.ec.escapi.UploadActivityResponse;
import in.gov.uidai.ec.escapi.enrollmentdetails.EnrollmentDetailsResponse;
import in.gov.uidai.ec.escapi.enrollmentdetails.FetchEnrollmentDetailsException;
import in.gov.uidai.ec.escapi.enrollmentdetails.FetchPacketStatusSummaryException;
import in.gov.uidai.ec.escapi.enrollmentdetails.PacketStatusSummary;
import in.gov.uidai.ec.escapi.packet.metadata.AutoPacketMetadataEnvelope;
import in.gov.uidai.ec.escapi.packet.metadata.MetaDataApiException;
import in.gov.uidai.ec.escapi.packet.metadata.MetaDataDateFormats;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class EnrolServiceClient {
    private static final String BASE_HOST_NAME = "127.0.0.1";
    private static final Integer BASE_HOST_PORT = 4421;
    private static final String ESC_PING_PATH = "/ouc/ping";
    private static final String ESC_REGISTRATION_PATH = "/ouc/registration";
    private static final String ESC_DE_REGISTRATION_PATH = "/ouc/deregistration";
    private static final String APPLICATION_JSON_TYPE = "application/json";
    private static final String ESC_UPLOAD_ACTIVITY_PATH = "/ouc/uploadactivity";
    private static final String ESC_OPERATOR_DETAILS_BATCH = "/ouc/operatordetails/batch";
    private static final String ESC_OPERATOR_DETAILS = "/ouc/operatordetails";
    private static final String ESC_LAST_PACKET_SIGNATURE = "/ouc/lastpacket/signature";
    private static final String ESC_PACKET_METADATA_V2 = "/ouc/packet/metadata/v2";
    protected static final String ESC_STATION_INFO_GPS = "/ouc/station/gps";
    protected static final String ESC_STATION_INFO_SCANNER = "/ouc/station/scanner";
    protected static final String ESC_STATION_INFO_LOCALISATION = "/ouc/station/localisation";
    protected static final String ESC_STATION_INFO_PRINTAADHAR = "/ouc/station/printaadhar";
    protected static final String ESC_STATION_INFO_ENROLMENT = "/ouc/station/enrolment";
    protected static final String ESC_STATION_INFO_SETTINGS = "/ouc/station/settings";
    protected static final String ESC_STATION_INFO_CHARGES = "/ouc/station/charges";
    protected static final String ESC_STATION_INFO_CHECKSUM = "/ouc/station/checksum";
    protected static final String APPLICATION_JSON = "application/json";
    private static final String ESC_PACKET_STATUS_WISE_SUMMARY = "/ouc/packetstatus/summary";
    private static final String ESC_ENROLLMENT_DETAILS = "/ouc/enrollment/details";
    private final CloseableHttpClient client = HttpClients.createDefault();

    EnrolServiceClient() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PingResponse ping() throws EnrolServiceClientApiException {
        URL url;
        try {
            url = new URL("http", BASE_HOST_NAME, BASE_HOST_PORT, ESC_PING_PATH);
        }
        catch (MalformedURLException e) {
            throw new EnrolServiceClientApiException(EnrolServiceClientApiError.ConnectionError, String.format("invalid url, %s, %s, %s", BASE_HOST_NAME, BASE_HOST_PORT, ESC_PING_PATH));
        }
        HttpGet pingRequest = new HttpGet(url.toString());
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)pingRequest);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new EnrolServiceClientApiException(EnrolServiceClientApiError.UnexpectedResponse, String.format("Ping API returned unexpected status code: %d", statusCode));
            }
            InputStream content = httpResponse.getEntity().getContent();
            ObjectMapper objectMapper = new ObjectMapper();
            PingResponse pingResponse = (PingResponse)objectMapper.readValue(content, PingResponse.class);
            return pingResponse;
        }
        catch (EnrolServiceClientApiException e) {
            throw e;
        }
        catch (JsonProcessingException e) {
            throw new EnrolServiceClientApiException(EnrolServiceClientApiError.UnexpectedResponse, "Error reading ping response from Aadhaar Enrol Service Client", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new EnrolServiceClientApiException(EnrolServiceClientApiError.ConnectionError, "Error connecting or reading ping response from Aadhaar Enrol Service Client", e);
        }
        catch (Exception e) {
            throw new EnrolServiceClientApiException(EnrolServiceClientApiError.Unknown, "Unknown error when getting ping response from Aadhaar Enrol Service Client", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UploadActivityResponse getPacketUploadActivity() throws EnrolServiceClientApiException {
        URL url;
        try {
            url = new URL("http", BASE_HOST_NAME, BASE_HOST_PORT, ESC_UPLOAD_ACTIVITY_PATH);
        }
        catch (MalformedURLException e) {
            throw new EnrolServiceClientApiException(EnrolServiceClientApiError.ConnectionError, String.format("invalid url, %s, %s, %s", BASE_HOST_NAME, BASE_HOST_PORT, ESC_UPLOAD_ACTIVITY_PATH));
        }
        HttpGet uploadActivityRequest = new HttpGet(url.toString());
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)uploadActivityRequest);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new EnrolServiceClientApiException(EnrolServiceClientApiError.UnexpectedResponse, String.format("Upload activity API returned unexpected status code: %d", statusCode));
            }
            InputStream content = httpResponse.getEntity().getContent();
            ObjectMapper objectMapper = new ObjectMapper();
            UploadActivityResponse uploadActivityResponse = (UploadActivityResponse)objectMapper.readValue(content, UploadActivityResponse.class);
            return uploadActivityResponse;
        }
        catch (EnrolServiceClientApiException e) {
            throw e;
        }
        catch (JsonProcessingException e) {
            throw new EnrolServiceClientApiException(EnrolServiceClientApiError.UnexpectedResponse, "Error reading upload activity response from Aadhaar Enrol Service Client", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new EnrolServiceClientApiException(EnrolServiceClientApiError.ConnectionError, "Error connecting or reading upload activity response from Aadhaar Enrol Service Client", e);
        }
        catch (Exception e) {
            throw new EnrolServiceClientApiException(EnrolServiceClientApiError.Unknown, "Unknown error when getting upload activity from Aadhaar Enrol Service Client", e);
        }
    }

    public void storeRegistrationInfo(RegistrationInfo registrationInfo) throws StoreRegistrationException, IOException {
        HttpPost storeRegistrationReq = new HttpPost(new URL("http", BASE_HOST_NAME, BASE_HOST_PORT, ESC_REGISTRATION_PATH).toString());
        storeRegistrationReq.setHeader("Content-Type", "application/json");
        ObjectMapper objectMapper = new ObjectMapper();
        byte[] bytes = objectMapper.writeValueAsBytes((Object)registrationInfo);
        storeRegistrationReq.setEntity((HttpEntity)new ByteArrayEntity(bytes));
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)storeRegistrationReq);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new StoreRegistrationException(String.format("Storing registration details in Aadhaar Enrol Service Client returned unknown status code: %d", statusCode));
            }
        }
    }

    public void saveMetadataToTmpDir(AutoPacketMetadataEnvelope envelope) {
        try {
            HttpPost writeMetaDataRequest = new HttpPost(new URL("http", BASE_HOST_NAME, BASE_HOST_PORT, ESC_PACKET_METADATA_V2).toString());
            writeMetaDataRequest.setHeader("Content-Type", "application/json");
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            SimpleDateFormat sdf = new SimpleDateFormat(MetaDataDateFormats.RFC_3339_DATE_FORMAT.getFormat());
            objectMapper.setDateFormat((DateFormat)sdf);
            byte[] bytes = objectMapper.writeValueAsBytes((Object)envelope);
            writeMetaDataRequest.setEntity((HttpEntity)new ByteArrayEntity(bytes));
            try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)writeMetaDataRequest);){
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new MetaDataApiException(String.format("while writing metadata.json in OUC service, returned unknown status code: %d", statusCode));
                }
            }
        }
        catch (JsonProcessingException ex) {
            throw new MetaDataApiException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new MetaDataApiException("exception occurred while writing metadata.json");
        }
    }

    public RegistrationInfo fetchRegistrationInfo() throws FetchRegistrationException, IOException {
        HttpGet fetchRegistrationReq = new HttpGet(new URL("http", BASE_HOST_NAME, BASE_HOST_PORT, ESC_REGISTRATION_PATH).toString());
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)fetchRegistrationReq);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new FetchRegistrationException(String.format("Fetching registration details from Aadhaar Enrol Service Client returned unknown status code: %d", statusCode));
            }
            InputStream content = httpResponse.getEntity().getContent();
            ObjectMapper objectMapper = new ObjectMapper();
            RegistrationInfo registrationInfo = (RegistrationInfo)objectMapper.readValue(content, RegistrationInfo.class);
            return registrationInfo;
        }
    }

    public void storeStationInfo(StationInfo stationInfo) throws StationInfoStoreException, IOException {
        HttpPost storeStationReq = new HttpPost(new URL("http", BASE_HOST_NAME, BASE_HOST_PORT, stationInfo.getPath()).toString());
        storeStationReq.setHeader("Content-Type", "application/json");
        ObjectMapper objectMapper = new ObjectMapper();
        byte[] bytes = objectMapper.writeValueAsBytes((Object)stationInfo);
        storeStationReq.setEntity((HttpEntity)new ByteArrayEntity(bytes));
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)storeStationReq);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new StationInfoStoreException(String.format("Storing %s details in OUC service returned unknown status code: %d", stationInfo.getClass().getName(), statusCode));
            }
        }
    }

    public StationInfo fetchStationInfo(String stationInfoPath) throws StationInfoStoreException, IOException {
        HttpGet fetchStationInfoReq = new HttpGet(new URL("http", BASE_HOST_NAME, BASE_HOST_PORT, stationInfoPath).toString());
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)fetchStationInfoReq);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new StationInfoStoreException(String.format("Fetching details from OUC service returned unknown status code: %d", statusCode));
            }
            InputStream content = httpResponse.getEntity().getContent();
            ObjectMapper objectMapper = new ObjectMapper();
            StationInfo stationInfo = (StationInfo)objectMapper.readValue(content, this.getStationInfoType(stationInfoPath));
            return stationInfo;
        }
    }

    private Class<?> getStationInfoType(String stationInfoPath) throws StationInfoStoreException {
        switch (stationInfoPath) {
            case "/ouc/station/gps": {
                return GpsInfo.class;
            }
            case "/ouc/station/scanner": {
                return ScannerInfo.class;
            }
            case "/ouc/station/localisation": {
                return LocalisationInfo.class;
            }
            case "/ouc/station/printaadhar": {
                return PrintAadharInfo.class;
            }
            case "/ouc/station/enrolment": {
                return EnrolmentInfo.class;
            }
            case "/ouc/station/settings": {
                return StationSettingsInfo.class;
            }
            case "/ouc/station/charges": {
                return ChargesInfo.class;
            }
            case "/ouc/station/checksum": {
                return ChecksumInfo.class;
            }
        }
        throw new StationInfoStoreException("Unexpected path for fetch from ouc: " + stationInfoPath);
    }

    public void startDeRegistration() throws StartDeRegistrationException, IOException {
        HttpPost startDeRegReq = new HttpPost(new URL("http", BASE_HOST_NAME, BASE_HOST_PORT, ESC_DE_REGISTRATION_PATH).toString());
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)startDeRegReq);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new StartDeRegistrationException(String.format("Starting de registration in Aadhaar Enrol Service Client returned unknown status code: %d", statusCode));
            }
        }
    }

    public void completeDeRegistration() throws CompleteDeRegistrationException, IOException {
        HttpDelete completeDeRegReq = new HttpDelete(new URL("http", BASE_HOST_NAME, BASE_HOST_PORT, ESC_DE_REGISTRATION_PATH).toString());
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)completeDeRegReq);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new CompleteDeRegistrationException(String.format("Completing de registration in Aadhaar Enrol Service Client returned unknown status code: %d", statusCode));
            }
        }
    }

    public void storeOperatorDetailsInBatch(Map<String, OperatorInfo> operatorDetails) throws StoreRegistrationException, IOException {
        HttpPost storeOperatorDetailsReq = new HttpPost(new URL("http", BASE_HOST_NAME, BASE_HOST_PORT, ESC_OPERATOR_DETAILS_BATCH).toString());
        storeOperatorDetailsReq.setHeader("Content-Type", "application/json");
        ObjectMapper objectMapper = new ObjectMapper();
        byte[] bytes = objectMapper.writeValueAsBytes(operatorDetails);
        storeOperatorDetailsReq.setEntity((HttpEntity)new ByteArrayEntity(bytes));
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)storeOperatorDetailsReq);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new StoreOperatorDetailException(String.format("Storing operator details in batch in Aadhaar Enrol Service Client returned unknown status code: %d", statusCode));
            }
        }
    }

    public Map<String, OperatorInfo> fetchOperatorDetailsInBatch(List<String> ids) throws FetchOperatorDetailException, IOException {
        URI uri;
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme("http").setHost(BASE_HOST_NAME).setPort(BASE_HOST_PORT.intValue()).setPath(ESC_OPERATOR_DETAILS_BATCH);
        ids.forEach(id -> uriBuilder.addParameter("operatorId", id));
        try {
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new FetchOperatorDetailException(String.format("Fetching operator details in batch from Aadhaar Enrol Service Client returned url syntax error: %s", e.getMessage()));
        }
        HttpGet fetchOperatorDetailsReq = new HttpGet(uri);
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)fetchOperatorDetailsReq);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new FetchOperatorDetailException(String.format("Fetching operator details  in batch from Aadhaar Enrol Service Client returned unknown status code: %d", statusCode));
            }
            InputStream content = httpResponse.getEntity().getContent();
            ObjectMapper objectMapper = new ObjectMapper();
            Map map = (Map)objectMapper.readValue(content, (TypeReference)new TypeReference<Map<String, OperatorInfo>>(){});
            return map;
        }
    }

    public OperatorInfo fetchOperatorDetails(String id) throws FetchOperatorDetailException, IOException {
        URI uri;
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme("http").setHost(BASE_HOST_NAME).setPort(BASE_HOST_PORT.intValue()).setPath(ESC_OPERATOR_DETAILS).addParameter("operatorId", id);
        try {
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new FetchOperatorDetailException(String.format("Fetching operator details from Aadhaar Enrol Service Client returned url syntax error: %s", e.getMessage()));
        }
        HttpGet fetchOperatorDetailsReq = new HttpGet(uri);
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)fetchOperatorDetailsReq);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new FetchOperatorDetailException(String.format("Fetching operator details from Aadhaar Enrol Service Client returned unknown status code: %d", statusCode));
            }
            InputStream content = httpResponse.getEntity().getContent();
            ObjectMapper objectMapper = new ObjectMapper();
            OperatorInfo operatorInfo = (OperatorInfo)objectMapper.readValue(content, OperatorInfo.class);
            return operatorInfo;
        }
    }

    public void storeOperatorDetails(String id, OperatorInfo operatorInfo) throws StoreRegistrationException, IOException {
        URI uri;
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme("http").setHost(BASE_HOST_NAME).setPort(BASE_HOST_PORT.intValue()).setPath(ESC_OPERATOR_DETAILS).addParameter("operatorId", id);
        try {
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new FetchOperatorDetailException(String.format("Storing operator details in Aadhaar Enrol Service Client returned url syntax error: %s", e.getMessage()));
        }
        HttpPost storeOperatorDetailsReq = new HttpPost(uri);
        storeOperatorDetailsReq.setHeader("Content-Type", "application/json");
        ObjectMapper objectMapper = new ObjectMapper();
        byte[] bytes = objectMapper.writeValueAsBytes((Object)operatorInfo);
        storeOperatorDetailsReq.setEntity((HttpEntity)new ByteArrayEntity(bytes));
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)storeOperatorDetailsReq);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new StoreOperatorDetailException(String.format("Storing operator details in Aadhaar Enrol Service Client returned unknown status code: %d", statusCode));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLastPacketSignature() throws EnrolServiceClientApiException {
        URL url;
        try {
            url = new URL("http", BASE_HOST_NAME, BASE_HOST_PORT, ESC_LAST_PACKET_SIGNATURE);
        }
        catch (MalformedURLException e) {
            throw new EnrolServiceClientApiException(EnrolServiceClientApiError.ConnectionError, String.format("invalid url, %s, %s, %s", BASE_HOST_NAME, BASE_HOST_PORT, ESC_LAST_PACKET_SIGNATURE));
        }
        HttpGet lastPacketSignatureRequest = new HttpGet(url.toString());
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)lastPacketSignatureRequest);){
            String line;
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new EnrolServiceClientApiException(EnrolServiceClientApiError.UnexpectedResponse, String.format("Last packet signature API returned unexpected status code: %d", statusCode));
            }
            InputStream content = httpResponse.getEntity().getContent();
            StringBuilder lastPacketSignature = new StringBuilder();
            BufferedReader rd = new BufferedReader(new InputStreamReader(content));
            while ((line = rd.readLine()) != null) {
                lastPacketSignature.append(line);
            }
            String string = lastPacketSignature.toString();
            return string;
        }
        catch (EnrolServiceClientApiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EnrolServiceClientApiException(EnrolServiceClientApiError.Unknown, "Unknown error when getting last packet signature from Aadhaar Enrol Service Client", e);
        }
    }

    public PacketStatusSummary fetchPacketStatusWiseSummary() throws FetchPacketStatusSummaryException, IOException {
        HttpGet fetchPacketStatusWiseSummaryReq = new HttpGet(new URL("http", BASE_HOST_NAME, BASE_HOST_PORT, ESC_PACKET_STATUS_WISE_SUMMARY).toString());
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)fetchPacketStatusWiseSummaryReq);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new FetchPacketStatusSummaryException(String.format("Fetching packet status wise summary from Aadhaar Enrol Service Client returned unknown status code: %d", statusCode));
            }
            InputStream content = httpResponse.getEntity().getContent();
            ObjectMapper objectMapper = new ObjectMapper();
            PacketStatusSummary packetStatusSummary = (PacketStatusSummary)objectMapper.readValue(content, PacketStatusSummary.class);
            return packetStatusSummary;
        }
    }

    public List<EnrollmentDetailsResponse> fetchEnrollmentDetails(String searchKey, List<String> searchValues) throws FetchEnrollmentDetailsException, IOException {
        URI uri;
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme("http").setHost(BASE_HOST_NAME).setPort(BASE_HOST_PORT.intValue()).setPath(ESC_ENROLLMENT_DETAILS).addParameter("searchKey", searchKey);
        searchValues.forEach(searchValue -> uriBuilder.addParameter("searchValue", searchValue));
        try {
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new FetchEnrollmentDetailsException(String.format("Fetching enrollment details from Aadhaar Enrol Service Client returned url syntax error: %s", e.getMessage()));
        }
        HttpGet fetchEnrollmentDetailsReq = new HttpGet(uri);
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)fetchEnrollmentDetailsReq);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new FetchEnrollmentDetailsException(String.format("Fetching enrollment details from Aadhaar Enrol Service Client returned unknown status code: %d", statusCode));
            }
            InputStream content = httpResponse.getEntity().getContent();
            ObjectMapper objectMapper = new ObjectMapper();
            List list = (List)objectMapper.readValue(content, (TypeReference)new TypeReference<List<EnrollmentDetailsResponse>>(){});
            return list;
        }
    }
}

