/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.escapi.packet.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import in.gov.uidai.ec.escapi.packet.metadata.MetaDataDateFormats;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class EnrolmentMetadata {
    private String eid;
    private String appointmentId;
    private String enrolmentType;
    private String mobile;
    private String isdCode;
    private String emailId;
    private Date createTimestamp;
    private String supervisorId;
    private String introducerId;
    private String sequenceNo;
    private String biometricException;
    private String languageCode;
    private String residentName;
    private String nprNumber;
    private boolean isNriEnrollment;
    private boolean isBiometricsMandatory;
    private String amount;
    private String gstCharged;
    private String totalAmountCharged;
    private String linkId;
    private String hmacSign;
    private String qualityWarn;
    private String packetHash;
    private StringBuilder updatedBitValues;
    private static final DecimalFormat AMOUNT_FORMAT = new DecimalFormat("0.00");

    EnrolmentMetadata() {
    }

    public EnrolmentMetadata(String eid, String appointmentId, String enrolmentType, Date createTimestamp, String supervisorId, String introducerId, String sequenceNo, String biometricException, String languageCode, String packetHash, String mobile, String isdCode, String emailId, StringBuilder updatedBitValues) {
        this.eid = eid;
        this.appointmentId = appointmentId;
        this.createTimestamp = createTimestamp;
        this.mobile = mobile;
        this.isdCode = isdCode;
        this.emailId = emailId;
        this.supervisorId = supervisorId;
        this.introducerId = introducerId;
        this.sequenceNo = sequenceNo;
        this.enrolmentType = enrolmentType;
        this.biometricException = biometricException;
        this.languageCode = languageCode;
        this.linkId = null;
        this.hmacSign = null;
        this.qualityWarn = null;
        this.packetHash = packetHash;
        this.updatedBitValues = updatedBitValues;
    }

    public void toByteArray(ByteArrayOutputStream out) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat(MetaDataDateFormats.RFC_3339_DATE_FORMAT.getFormat());
        this.writeBytes(out, this.eid);
        this.writeBytes(out, this.appointmentId);
        this.writeBytes(out, this.enrolmentType);
        this.writeBytes(out, this.mobile);
        this.writeBytes(out, this.isdCode);
        this.writeBytes(out, this.emailId);
        this.writeBytes(out, sdf.format(this.createTimestamp));
        this.writeBytes(out, this.supervisorId);
        this.writeBytes(out, this.introducerId);
        this.writeBytes(out, this.sequenceNo);
        this.writeBytes(out, this.biometricException);
        this.writeBytes(out, this.languageCode);
        this.writeBytes(out, this.linkId);
        this.writeBytes(out, this.hmacSign);
        this.writeBytes(out, this.qualityWarn);
        this.writeBytes(out, this.packetHash);
        this.writeBytes(out, String.valueOf(this.updatedBitValues));
        this.writeBytes(out, this.residentName);
        this.writeBytes(out, this.nprNumber);
        this.writeBytes(out, Boolean.toString(this.isNriEnrollment));
        this.writeBytes(out, Boolean.toString(this.isBiometricsMandatory));
        this.writeBytes(out, this.amount);
        this.writeBytes(out, this.gstCharged);
        this.writeBytes(out, this.totalAmountCharged);
    }

    private void writeBytes(ByteArrayOutputStream out, String value) throws IOException {
        if (value == null || value.equals("")) {
            return;
        }
        out.write(value.getBytes());
    }

    public String getResidentName() {
        return this.residentName;
    }

    public void setResidentName(String residentName) {
        this.residentName = residentName;
    }

    public void setNprNumber(String nprNumber) {
        this.nprNumber = nprNumber;
    }

    public void setNriEnrollment(Boolean nriEnrollment) {
        this.isNriEnrollment = nriEnrollment;
    }

    public void setBiometricsMandatory(Boolean biometricsMandatory) {
        this.isBiometricsMandatory = biometricsMandatory;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(Float amount) {
        this.amount = AMOUNT_FORMAT.format(amount);
    }

    public void setGstCharged(Float gstCharged) {
        this.gstCharged = AMOUNT_FORMAT.format(gstCharged);
    }

    public void setTotalAmountCharged(Float totalAmountCharged) {
        this.totalAmountCharged = AMOUNT_FORMAT.format(totalAmountCharged);
    }
}

