/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.escapi.packet.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import in.gov.uidai.ec.escapi.packet.metadata.EnrolStatus;
import in.gov.uidai.ec.escapi.packet.metadata.MetaDataDateFormats;
import in.gov.uidai.ec.service.packet.PacketVerifyType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.datatype.XMLGregorianCalendar;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class PacketStatusMetadata {
    private EnrolStatus status;
    private String actor;
    private String packetSize;
    private String locationCode;
    private XMLGregorianCalendar date;
    private XMLGregorianCalendar exportDate;
    private PacketVerifyType packetVerifyType;

    public EnrolStatus getStatus() {
        return this.status;
    }

    public void setStatus(EnrolStatus status) {
        this.status = status;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public String getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(String packetSize) {
        this.packetSize = packetSize;
    }

    public String getLocationCode() {
        return this.locationCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    public XMLGregorianCalendar getDate() {
        return this.date;
    }

    public void setDate(XMLGregorianCalendar date) {
        this.date = date;
    }

    public XMLGregorianCalendar getExportDate() {
        return this.exportDate;
    }

    public void setExportDate(XMLGregorianCalendar exportDate) {
        this.exportDate = exportDate;
    }

    public void toByteArray(ByteArrayOutputStream out) throws IOException {
        this.writeBytes(out, this.status.value());
        this.writeBytes(out, this.actor);
        this.writeBytes(out, this.packetSize);
        this.writeBytes(out, this.locationCode);
        if (this.date != null) {
            ZonedDateTime statusDate = this.date.toGregorianCalendar().toZonedDateTime();
            this.writeBytes(out, statusDate.format(DateTimeFormatter.ofPattern(MetaDataDateFormats.RFC_3339_DATE_FORMAT.getFormat())));
        }
        if (this.exportDate != null) {
            ZonedDateTime pktExportDate = this.exportDate.toGregorianCalendar().toZonedDateTime();
            this.writeBytes(out, pktExportDate.format(DateTimeFormatter.ofPattern(MetaDataDateFormats.RFC_3339_DATE_FORMAT.getFormat())));
        }
        if (this.packetVerifyType != null) {
            this.writeBytes(out, this.packetVerifyType.name());
        }
    }

    private void writeBytes(ByteArrayOutputStream out, String value) throws IOException {
        if (value == null || value.equals("")) {
            return;
        }
        out.write(value.getBytes());
    }

    public void setPacketVerifyType(PacketVerifyType packetVerifyType) {
        this.packetVerifyType = packetVerifyType;
    }
}

