/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.curves;

import georegression.struct.curve.EllipseRotated_F64;
import georegression.struct.point.Point2D_F64;

public class ClosestPointEllipseAngle_F64 {
    double tol;
    int maxIterations;
    Point2D_F64 closest = new Point2D_F64();
    EllipseRotated_F64 ellipse;
    double ce;
    double se;
    double theta;

    public ClosestPointEllipseAngle_F64(double tol, int maxIterations) {
        this.tol = tol;
        this.maxIterations = maxIterations;
    }

    public void setEllipse(EllipseRotated_F64 ellipse) {
        this.ellipse = ellipse;
        this.ce = Math.cos(ellipse.phi);
        this.se = Math.sin(ellipse.phi);
    }

    public void process(Point2D_F64 point) {
        double s;
        double c;
        double f;
        double xc = point.x - this.ellipse.center.x;
        double yc = point.y - this.ellipse.center.y;
        double x = this.ce * xc + this.se * yc;
        double y = -this.se * xc + this.ce * yc;
        this.theta = Math.atan2(this.ellipse.a * y, this.ellipse.b * x);
        double a2_m_b2 = this.ellipse.a * this.ellipse.a - this.ellipse.b * this.ellipse.b;
        for (int i = 0; i < this.maxIterations && !(Math.abs(f = a2_m_b2 * (c = Math.cos(this.theta)) * (s = Math.sin(this.theta)) - x * this.ellipse.a * s + y * this.ellipse.b * c) < this.tol); ++i) {
            double d = a2_m_b2 * (c * c - s * s) - x * this.ellipse.a * c - y * this.ellipse.b * s;
            this.theta -= f / d;
        }
        x = this.ellipse.a * Math.cos(this.theta);
        y = this.ellipse.b * Math.sin(this.theta);
        this.closest.x = this.ce * x - this.se * y + this.ellipse.center.x;
        this.closest.y = this.se * x + this.ce * y + this.ellipse.center.y;
    }

    public Point2D_F64 getClosest() {
        return this.closest;
    }

    public double getTheta() {
        return this.theta;
    }
}

