/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.curves;

import georegression.fitting.FitShapeToPoints_F32;
import georegression.struct.curve.ConicGeneral_F32;
import georegression.struct.point.Point2D_F32;
import java.util.List;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_FDRM;
import org.ejml.interfaces.SolveNullSpace;

public class FitConicA_F32
implements FitShapeToPoints_F32<Point2D_F32, ConicGeneral_F32> {
    private SolveNullSpace<FMatrixRMaj> solver = new SolveNullSpaceSvd_FDRM();
    private FMatrixRMaj A = new FMatrixRMaj(6, 6);
    private FMatrixRMaj nullspace = new FMatrixRMaj(6, 1);

    @Override
    public boolean process(List<Point2D_F32> points, ConicGeneral_F32 output) {
        int N = points.size();
        if (N < 3) {
            throw new IllegalArgumentException("At least 3 points required");
        }
        this.A.reshape(N, 6);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            Point2D_F32 p = points.get(i);
            float x = p.x;
            float y = p.y;
            this.A.data[index++] = x * x;
            this.A.data[index++] = x * y;
            this.A.data[index++] = y * y;
            this.A.data[index++] = x;
            this.A.data[index++] = y;
            this.A.data[index++] = 1.0f;
        }
        if (!this.solver.process((Matrix)this.A, 1, (Matrix)this.nullspace)) {
            return false;
        }
        output.A = this.nullspace.data[0];
        output.B = this.nullspace.data[1];
        output.C = this.nullspace.data[2];
        output.D = this.nullspace.data[3];
        output.E = this.nullspace.data[4];
        output.F = this.nullspace.data[5];
        return true;
    }

    @Override
    public boolean process(List<Point2D_F32> points, float[] weights, ConicGeneral_F32 output) {
        int N = points.size();
        if (N < 3) {
            throw new IllegalArgumentException("At least 3 points required");
        }
        this.A.reshape(N, 6);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            Point2D_F32 p = points.get(i);
            float w = weights[i];
            float x = p.x;
            float y = p.y;
            this.A.data[index++] = w * x * x;
            this.A.data[index++] = w * x * y;
            this.A.data[index++] = w * y * y;
            this.A.data[index++] = w * x;
            this.A.data[index++] = w * y;
            this.A.data[index++] = w;
        }
        if (!this.solver.process((Matrix)this.A, 1, (Matrix)this.nullspace)) {
            return false;
        }
        output.A = this.nullspace.data[0];
        output.B = this.nullspace.data[1];
        output.C = this.nullspace.data[2];
        output.D = this.nullspace.data[3];
        output.E = this.nullspace.data[4];
        output.F = this.nullspace.data[5];
        return true;
    }

    public SolveNullSpace<FMatrixRMaj> getSolver() {
        return this.solver;
    }

    public void setSolver(SolveNullSpace<FMatrixRMaj> solver) {
        this.solver = solver;
    }
}

