/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.curves;

import georegression.fitting.FitShapeToPoints_F64;
import georegression.struct.curve.ConicGeneral_F64;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;
import org.ejml.interfaces.SolveNullSpace;

public class FitConicA_F64
implements FitShapeToPoints_F64<Point2D_F64, ConicGeneral_F64> {
    private SolveNullSpace<DMatrixRMaj> solver = new SolveNullSpaceSvd_DDRM();
    private DMatrixRMaj A = new DMatrixRMaj(6, 6);
    private DMatrixRMaj nullspace = new DMatrixRMaj(6, 1);

    @Override
    public boolean process(List<Point2D_F64> points, ConicGeneral_F64 output) {
        int N = points.size();
        if (N < 3) {
            throw new IllegalArgumentException("At least 3 points required");
        }
        this.A.reshape(N, 6);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            Point2D_F64 p = points.get(i);
            double x = p.x;
            double y = p.y;
            this.A.data[index++] = x * x;
            this.A.data[index++] = x * y;
            this.A.data[index++] = y * y;
            this.A.data[index++] = x;
            this.A.data[index++] = y;
            this.A.data[index++] = 1.0;
        }
        if (!this.solver.process((Matrix)this.A, 1, (Matrix)this.nullspace)) {
            return false;
        }
        output.A = this.nullspace.data[0];
        output.B = this.nullspace.data[1];
        output.C = this.nullspace.data[2];
        output.D = this.nullspace.data[3];
        output.E = this.nullspace.data[4];
        output.F = this.nullspace.data[5];
        return true;
    }

    @Override
    public boolean process(List<Point2D_F64> points, double[] weights, ConicGeneral_F64 output) {
        int N = points.size();
        if (N < 3) {
            throw new IllegalArgumentException("At least 3 points required");
        }
        this.A.reshape(N, 6);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            Point2D_F64 p = points.get(i);
            double w = weights[i];
            double x = p.x;
            double y = p.y;
            this.A.data[index++] = w * x * x;
            this.A.data[index++] = w * x * y;
            this.A.data[index++] = w * y * y;
            this.A.data[index++] = w * x;
            this.A.data[index++] = w * y;
            this.A.data[index++] = w;
        }
        if (!this.solver.process((Matrix)this.A, 1, (Matrix)this.nullspace)) {
            return false;
        }
        output.A = this.nullspace.data[0];
        output.B = this.nullspace.data[1];
        output.C = this.nullspace.data[2];
        output.D = this.nullspace.data[3];
        output.E = this.nullspace.data[4];
        output.F = this.nullspace.data[5];
        return true;
    }

    public SolveNullSpace<DMatrixRMaj> getSolver() {
        return this.solver;
    }

    public void setSolver(SolveNullSpace<DMatrixRMaj> solver) {
        this.solver = solver;
    }
}

