/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.curves;

import georegression.struct.curve.PolynomialCurve_F32;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.factory.LinearSolverFactory_FDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class FitPolynomialSolverTall_F32 {
    LinearSolverDense<FMatrixRMaj> solver;
    FMatrixRMaj A = new FMatrixRMaj(1, 1);
    FMatrixRMaj b = new FMatrixRMaj(1, 1);
    FMatrixRMaj x = new FMatrixRMaj(1, 1);

    public FitPolynomialSolverTall_F32(LinearSolverDense<FMatrixRMaj> solver) {
        this.solver = solver;
    }

    public FitPolynomialSolverTall_F32() {
        this((LinearSolverDense<FMatrixRMaj>)LinearSolverFactory_FDRM.qrp((boolean)true, (boolean)false));
    }

    public boolean process(float[] data, int offset, int length, PolynomialCurve_F32 output) {
        int i;
        int N = length / 2;
        int numCoefs = output.size();
        this.A.reshape(N, numCoefs);
        this.b.reshape(N, 1);
        this.x.reshape(numCoefs, 1);
        int end = offset + length;
        int idxA = 0;
        for (i = offset; i < end; i += 2) {
            float x = data[i];
            float y = data[i + 1];
            float pow = 1.0f;
            for (int j = 0; j < numCoefs; ++j) {
                this.A.data[idxA++] = pow;
                pow *= x;
            }
            this.b.data[i / 2] = y;
        }
        if (!this.solver.setA((Matrix)this.A)) {
            return false;
        }
        this.solver.solve((Matrix)this.b, (Matrix)this.x);
        for (i = 0; i < numCoefs; ++i) {
            output.set(i, this.x.data[i]);
        }
        return true;
    }
}

