/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.curves;

import georegression.struct.curve.PolynomialCurve_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class FitPolynomialSolverTall_F64 {
    LinearSolverDense<DMatrixRMaj> solver;
    DMatrixRMaj A = new DMatrixRMaj(1, 1);
    DMatrixRMaj b = new DMatrixRMaj(1, 1);
    DMatrixRMaj x = new DMatrixRMaj(1, 1);

    public FitPolynomialSolverTall_F64(LinearSolverDense<DMatrixRMaj> solver) {
        this.solver = solver;
    }

    public FitPolynomialSolverTall_F64() {
        this((LinearSolverDense<DMatrixRMaj>)LinearSolverFactory_DDRM.qrp((boolean)true, (boolean)false));
    }

    public boolean process(double[] data, int offset, int length, PolynomialCurve_F64 output) {
        int i;
        int N = length / 2;
        int numCoefs = output.size();
        this.A.reshape(N, numCoefs);
        this.b.reshape(N, 1);
        this.x.reshape(numCoefs, 1);
        int end = offset + length;
        int idxA = 0;
        for (i = offset; i < end; i += 2) {
            double x = data[i];
            double y = data[i + 1];
            double pow = 1.0;
            for (int j = 0; j < numCoefs; ++j) {
                this.A.data[idxA++] = pow;
                pow *= x;
            }
            this.b.data[i / 2] = y;
        }
        if (!this.solver.setA((Matrix)this.A)) {
            return false;
        }
        this.solver.solve((Matrix)this.b, (Matrix)this.x);
        for (i = 0; i < numCoefs; ++i) {
            output.set(i, this.x.data[i]);
        }
        return true;
    }
}

