/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.plane;

import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import java.util.List;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.linsol.qr.SolveNullSpaceQRP_FDRM;
import org.ejml.interfaces.SolveNullSpace;

public class FitPlane3D_F32 {
    SolveNullSpace<FMatrixRMaj> solverNull = new SolveNullSpaceQRP_FDRM();
    FMatrixRMaj A = new FMatrixRMaj(3, 3);
    FMatrixRMaj nullspace = new FMatrixRMaj(3, 1);

    public boolean svd(List<Point3D_F32> points, Point3D_F32 outputCenter, Vector3D_F32 outputNormal) {
        int N = points.size();
        outputCenter.set(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < N; ++i) {
            Point3D_F32 p = points.get(i);
            outputCenter.x += p.x;
            outputCenter.y += p.y;
            outputCenter.z += p.z;
        }
        outputCenter.x /= (float)N;
        outputCenter.y /= (float)N;
        outputCenter.z /= (float)N;
        return this.solvePoint(points, outputCenter, outputNormal);
    }

    public boolean solvePoint(List<Point3D_F32> points, Point3D_F32 pointOnPlane, Vector3D_F32 outputNormal) {
        int N = points.size();
        this.A.reshape(N, 3);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            Point3D_F32 p = points.get(i);
            this.A.data[index++] = p.x - pointOnPlane.x;
            this.A.data[index++] = p.y - pointOnPlane.y;
            this.A.data[index++] = p.z - pointOnPlane.z;
        }
        if (!this.solverNull.process((Matrix)this.A, 1, (Matrix)this.nullspace)) {
            return false;
        }
        outputNormal.x = this.nullspace.unsafe_get(0, 0);
        outputNormal.y = this.nullspace.unsafe_get(1, 0);
        outputNormal.z = this.nullspace.unsafe_get(2, 0);
        return true;
    }
}

