/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.se;

import georegression.fitting.MotionTransformPoint;
import georegression.geometry.GeometryMath_F32;
import georegression.geometry.UtilPoint2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.se.Se2_F32;
import java.util.List;
import org.ejml.data.FMatrix1Row;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.factory.DecompositionFactory_FDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;

public class MotionSe2PointSVD_F32
implements MotionTransformPoint<Se2_F32, Point2D_F32> {
    Se2_F32 motion = new Se2_F32();
    Point2D_F32 meanFrom = new Point2D_F32();
    Point2D_F32 meanTo = new Point2D_F32();
    SingularValueDecomposition<FMatrixRMaj> svd = DecompositionFactory_FDRM.svd((int)2, (int)2, (boolean)true, (boolean)true, (boolean)false);
    FMatrixRMaj Sigma = new FMatrixRMaj(2, 2);
    FMatrixRMaj U = new FMatrixRMaj(2, 2);
    FMatrixRMaj V = new FMatrixRMaj(2, 2);
    FMatrixRMaj R = new FMatrixRMaj(2, 2);

    @Override
    public Se2_F32 getTransformSrcToDst() {
        return this.motion;
    }

    @Override
    public boolean process(List<Point2D_F32> srcPts, List<Point2D_F32> dstPts) {
        if (srcPts.size() != dstPts.size()) {
            throw new IllegalArgumentException("There must be a 1 to 1 correspondence between the two sets of points");
        }
        UtilPoint2D_F32.mean(srcPts, this.meanFrom);
        UtilPoint2D_F32.mean(dstPts, this.meanTo);
        int N = srcPts.size();
        float s11 = 0.0f;
        float s12 = 0.0f;
        float s21 = 0.0f;
        float s22 = 0.0f;
        float m11 = this.meanFrom.x * this.meanTo.x;
        float m12 = this.meanFrom.x * this.meanTo.y;
        float m21 = this.meanFrom.y * this.meanTo.x;
        float m22 = this.meanFrom.y * this.meanTo.y;
        for (int i = 0; i < N; ++i) {
            Point2D_F32 f = srcPts.get(i);
            Point2D_F32 t = dstPts.get(i);
            s11 += f.x * t.x;
            s12 += f.x * t.y;
            s21 += f.y * t.x;
            s22 += f.y * t.y;
        }
        s11 = s11 / (float)N - m11;
        s12 = s12 / (float)N - m12;
        s21 = s21 / (float)N - m21;
        s22 = s22 / (float)N - m22;
        this.Sigma.data[0] = s11;
        this.Sigma.data[1] = s12;
        this.Sigma.data[2] = s21;
        this.Sigma.data[3] = s22;
        if (!this.svd.decompose((Matrix)this.Sigma)) {
            return false;
        }
        this.svd.getU((Matrix)this.U, false);
        this.svd.getV((Matrix)this.V, false);
        CommonOps_FDRM.multTransB((FMatrix1Row)this.V, (FMatrix1Row)this.U, (FMatrix1Row)this.R);
        float det = CommonOps_FDRM.det((FMatrixRMaj)this.R);
        if (det < 0.0f) {
            for (int i = 0; i < 2; ++i) {
                this.V.set(i, 1, -this.V.get(i, 1));
            }
            CommonOps_FDRM.multTransB((FMatrix1Row)this.V, (FMatrix1Row)this.U, (FMatrix1Row)this.R);
            det = CommonOps_FDRM.det((FMatrixRMaj)this.R);
            if (det < 0.0f) {
                throw new RuntimeException("Crap");
            }
        }
        float yaw = (float)Math.atan2(this.R.get(1, 0), this.R.get(0, 0));
        GeometryMath_F32.rotate(yaw, this.meanFrom, this.meanFrom);
        this.motion.getTranslation().x = this.meanTo.x - this.meanFrom.x;
        this.motion.getTranslation().y = this.meanTo.y - this.meanFrom.y;
        this.motion.setYaw(yaw);
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

