/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.geometry.algs.TangentLinesTwoEllipses_F64;
import georegression.misc.GrlConstants;
import georegression.struct.curve.EllipseQuadratic_F64;
import georegression.struct.curve.EllipseRotated_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Vector2D_F64;

public class UtilEllipse_F64 {
    public static EllipseRotated_F64 convert(EllipseQuadratic_F64 input, EllipseRotated_F64 output) {
        double dy;
        double dx;
        if (output == null) {
            output = new EllipseRotated_F64();
        }
        double a11 = input.A;
        double a12 = input.B;
        double a22 = input.C;
        double b1 = 2.0 * input.D;
        double b2 = 2.0 * input.E;
        double c = input.F;
        output.center.x = (a22 * b1 - a12 * b2) / (2.0 * (a12 * a12 - a11 * a22));
        output.center.y = (a11 * b2 - a12 * b1) / (2.0 * (a12 * a12 - a11 * a22));
        double k1 = output.center.x;
        double k2 = output.center.y;
        double mu = 1.0 / (a11 * k1 * k1 + 2.0 * a12 * k1 * k2 + a22 * k2 * k2 - c);
        double m11 = mu * a11;
        double m12 = mu * a12;
        double m22 = mu * a22;
        double inner = Math.sqrt((m11 - m22) * (m11 - m22) + 4.0 * m12 * m12);
        double l1 = (m11 + m22 + inner) / 2.0;
        double l2 = (m11 + m22 - inner) / 2.0;
        output.b = 1.0 / Math.sqrt(l1);
        output.a = 1.0 / Math.sqrt(l2);
        if (m11 >= m22) {
            dx = l1 - m22;
            dy = m12;
        } else {
            dx = m12;
            dy = l1 - m11;
        }
        output.phi = Math.atan2(-dx, dy);
        if (output.phi < -GrlConstants.PId2) {
            output.phi += Math.PI;
        } else if (output.phi > GrlConstants.PId2) {
            output.phi -= Math.PI;
        }
        return output;
    }

    public static EllipseQuadratic_F64 convert(EllipseRotated_F64 input, EllipseQuadratic_F64 output) {
        if (output == null) {
            output = new EllipseQuadratic_F64();
        }
        double x0 = input.center.x;
        double y0 = input.center.y;
        double a = input.a;
        double b = input.b;
        double phi = input.phi;
        double cphi = Math.cos(phi);
        double sphi = Math.sin(phi);
        double cphi2 = cphi * cphi;
        double sphi2 = sphi * sphi;
        double a2 = a * a;
        double b2 = b * b;
        double x02 = x0 * x0;
        double y02 = y0 * y0;
        output.A = cphi2 / a2 + sphi2 / b2;
        output.B = sphi * cphi / a2 - sphi * cphi / b2;
        output.C = sphi2 / a2 + cphi2 / b2;
        output.D = -x0 * cphi2 / a2 - y0 * sphi * cphi / a2 - x0 * sphi2 / b2 + y0 * sphi * cphi / b2;
        output.E = -x0 * sphi * cphi / a2 - y0 * sphi2 / a2 + x0 * sphi * cphi / b2 - y0 * cphi2 / b2;
        output.F = x02 * cphi2 / a2 + 2.0 * x0 * y0 * sphi * cphi / a2 + y02 * sphi2 / a2 + x02 * sphi2 / b2 - 2.0 * x0 * y0 * sphi * cphi / b2 + y02 * cphi2 / b2 - 1.0;
        return output;
    }

    public static double evaluate(double x, double y, EllipseQuadratic_F64 ellipse) {
        return ellipse.A * x * x + 2.0 * ellipse.B * x * y + ellipse.C * y * y + 2.0 * ellipse.D * x + 2.0 * ellipse.E * y + ellipse.F;
    }

    public static double evaluate(double x, double y, EllipseRotated_F64 ellipse) {
        double cphi = Math.cos(ellipse.phi);
        double sphi = Math.sin(ellipse.phi);
        double left = (x -= ellipse.center.x) * cphi + (y -= ellipse.center.y) * sphi;
        double right = -x * sphi + y * cphi;
        double ll = left / ellipse.a;
        double rr = right / ellipse.b;
        return ll * ll + rr * rr;
    }

    public static Point2D_F64 computePoint(double t, EllipseRotated_F64 ellipse, Point2D_F64 output) {
        if (output == null) {
            output = new Point2D_F64();
        }
        double ct = Math.cos(t);
        double st = Math.sin(t);
        double cphi = Math.cos(ellipse.phi);
        double sphi = Math.sin(ellipse.phi);
        double x = ellipse.a * ct;
        double y = ellipse.b * st;
        output.x = ellipse.center.x + x * cphi - y * sphi;
        output.y = ellipse.center.y + x * sphi + y * cphi;
        return output;
    }

    public static double computeAngle(Point2D_F64 p, EllipseRotated_F64 ellipse) {
        double ce = Math.cos(ellipse.phi);
        double se = Math.sin(ellipse.phi);
        double xc = p.x - ellipse.center.x;
        double yc = p.y - ellipse.center.y;
        double x = ce * xc + se * yc;
        double y = -se * xc + ce * yc;
        return Math.atan2(y / ellipse.b, x / ellipse.a);
    }

    public static Vector2D_F64 computeTangent(double t, EllipseRotated_F64 ellipse, Vector2D_F64 output) {
        if (output == null) {
            output = new Vector2D_F64();
        }
        double ct = Math.cos(t);
        double st = Math.sin(t);
        double cphi = Math.cos(ellipse.phi);
        double sphi = Math.sin(ellipse.phi);
        double x = ellipse.a * ct * ellipse.b * ellipse.b;
        double y = ellipse.b * st * ellipse.a * ellipse.a;
        double rx = x * cphi - y * sphi;
        double ry = x * sphi + y * cphi;
        double r = Math.sqrt(rx * rx + ry * ry);
        output.x = -ry / r;
        output.y = rx / r;
        return output;
    }

    public static boolean tangentLines(Point2D_F64 pt, EllipseRotated_F64 ellipse, Point2D_F64 tangentA, Point2D_F64 tangentB) {
        double y1;
        double y0;
        double x1;
        double x0;
        double cphi = Math.cos(ellipse.phi);
        double sphi = Math.sin(ellipse.phi);
        double tmpx = pt.x - ellipse.center.x;
        double tmpy = pt.y - ellipse.center.y;
        double xt = tmpx * cphi + tmpy * sphi;
        double yt = -tmpx * sphi + tmpy * cphi;
        double a2 = ellipse.a * ellipse.a;
        double b2 = ellipse.b * ellipse.b;
        double aa0 = yt * yt / b2 + xt * xt / a2;
        double bb0 = -2.0 * xt;
        double cc0 = a2 * (1.0 - yt * yt / b2);
        double descriminant0 = bb0 * bb0 - 4.0 * aa0 * cc0;
        double aa1 = xt * xt / a2 + yt * yt / b2;
        double bb1 = -2.0 * yt;
        double cc1 = b2 * (1.0 - xt * xt / a2);
        double descriminant1 = bb1 * bb1 - 4.0 * aa1 * cc1;
        if (descriminant0 < 0.0 && descriminant1 < 0.0) {
            return false;
        }
        if (descriminant0 > descriminant1) {
            if (yt == 0.0) {
                return false;
            }
            double right = Math.sqrt(descriminant0);
            x0 = (-bb0 + right) / (2.0 * aa0);
            x1 = (-bb0 - right) / (2.0 * aa0);
            y0 = b2 / yt - xt * x0 * b2 / (yt * a2);
            y1 = b2 / yt - xt * x1 * b2 / (yt * a2);
        } else {
            if (xt == 0.0) {
                return false;
            }
            double right = Math.sqrt(descriminant1);
            y0 = (-bb1 + right) / (2.0 * aa1);
            y1 = (-bb1 - right) / (2.0 * aa1);
            x0 = a2 / xt - yt * y0 * a2 / (xt * b2);
            x1 = a2 / xt - yt * y1 * a2 / (xt * b2);
        }
        tangentA.x = x0 * cphi - y0 * sphi + ellipse.center.x;
        tangentA.y = x0 * sphi + y0 * cphi + ellipse.center.y;
        tangentB.x = x1 * cphi - y1 * sphi + ellipse.center.x;
        tangentB.y = x1 * sphi + y1 * cphi + ellipse.center.y;
        return true;
    }

    public static boolean tangentLines(EllipseRotated_F64 ellipseA, EllipseRotated_F64 ellipseB, Point2D_F64 tangentA0, Point2D_F64 tangentA1, Point2D_F64 tangentA2, Point2D_F64 tangentA3, Point2D_F64 tangentB0, Point2D_F64 tangentB1, Point2D_F64 tangentB2, Point2D_F64 tangentB3) {
        TangentLinesTwoEllipses_F64 alg = new TangentLinesTwoEllipses_F64(GrlConstants.TEST_F64, 10);
        return alg.process(ellipseA, ellipseB, tangentA0, tangentA1, tangentA2, tangentA3, tangentB0, tangentB1, tangentB2, tangentB3);
    }
}

