/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.geometry.UtilVector2D_F32;
import georegression.geometry.algs.AndrewMonotoneConvexHull_F32;
import georegression.metric.Distance2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.Polygon2D_F32;
import georegression.struct.shapes.Quadrilateral_F32;
import georegression.struct.shapes.Rectangle2D_F32;
import georegression.struct.shapes.RectangleLength2D_I32;
import java.util.List;

public class UtilPolygons2D_F32 {
    public static boolean isConvex(Polygon2D_F32 poly) {
        int N = poly.size();
        int numPositive = 0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            int k = (i + 2) % N;
            Point2D_F32 a = ((Point2D_F32[])poly.vertexes.data)[i];
            Point2D_F32 b = ((Point2D_F32[])poly.vertexes.data)[j];
            Point2D_F32 c = ((Point2D_F32[])poly.vertexes.data)[k];
            float dx0 = a.x - b.x;
            float dy1 = c.y - b.y;
            float dy0 = a.y - b.y;
            float dx1 = c.x - b.x;
            float z = dx0 * dy1 - dy0 * dx1;
            if (!(z > 0.0f)) continue;
            ++numPositive;
        }
        return numPositive == 0 || numPositive == N;
    }

    public static void convert(Rectangle2D_F32 input, Quadrilateral_F32 output) {
        output.a.x = input.p0.x;
        output.a.y = input.p0.y;
        output.b.x = input.p1.x;
        output.b.y = input.p0.y;
        output.c.x = input.p1.x;
        output.c.y = input.p1.y;
        output.d.x = input.p0.x;
        output.d.y = input.p1.y;
    }

    public static void convert(Rectangle2D_F32 input, Polygon2D_F32 output) {
        if (output.size() != 4) {
            throw new IllegalArgumentException("polygon of order 4 expected");
        }
        output.get(0).set(input.p0.x, input.p0.y);
        output.get(1).set(input.p1.x, input.p0.y);
        output.get(2).set(input.p1.x, input.p1.y);
        output.get(3).set(input.p0.x, input.p1.y);
    }

    public static void convert(Quadrilateral_F32 input, Polygon2D_F32 output) {
        if (output.size() != 4) {
            throw new IllegalArgumentException("polygon of order 4 expected");
        }
        output.get(0).set(input.a);
        output.get(1).set(input.b);
        output.get(2).set(input.c);
        output.get(3).set(input.d);
    }

    public static void convert(Polygon2D_F32 input, Quadrilateral_F32 output) {
        if (input.size() != 4) {
            throw new IllegalArgumentException("Expected 4-sided polygon as input");
        }
        output.a.set(input.get(0));
        output.b.set(input.get(1));
        output.c.set(input.get(2));
        output.d.set(input.get(3));
    }

    public static void convert(RectangleLength2D_I32 input, Quadrilateral_F32 output) {
        output.a.x = input.x0;
        output.a.y = input.y0;
        output.b.x = input.x0 + input.width - 1;
        output.b.y = input.y0;
        output.c.x = input.x0 + input.width - 1;
        output.c.y = input.y0 + input.height - 1;
        output.d.x = input.x0;
        output.d.y = input.y0 + input.height - 1;
    }

    public static void bounding(Quadrilateral_F32 quad, Rectangle2D_F32 rectangle) {
        rectangle.p0.x = Math.min(quad.a.x, quad.b.x);
        rectangle.p0.x = Math.min(rectangle.p0.x, quad.c.x);
        rectangle.p0.x = Math.min(rectangle.p0.x, quad.d.x);
        rectangle.p0.y = Math.min(quad.a.y, quad.b.y);
        rectangle.p0.y = Math.min(rectangle.p0.y, quad.c.y);
        rectangle.p0.y = Math.min(rectangle.p0.y, quad.d.y);
        rectangle.p1.x = Math.max(quad.a.x, quad.b.x);
        rectangle.p1.x = Math.max(rectangle.p1.x, quad.c.x);
        rectangle.p1.x = Math.max(rectangle.p1.x, quad.d.x);
        rectangle.p1.y = Math.max(quad.a.y, quad.b.y);
        rectangle.p1.y = Math.max(rectangle.p1.y, quad.c.y);
        rectangle.p1.y = Math.max(rectangle.p1.y, quad.d.y);
    }

    public static void bounding(Polygon2D_F32 polygon, Rectangle2D_F32 rectangle) {
        rectangle.p0.set(polygon.get(0));
        rectangle.p1.set(polygon.get(0));
        for (int i = 0; i < polygon.size(); ++i) {
            Point2D_F32 p = polygon.get(i);
            if (p.x < rectangle.p0.x) {
                rectangle.p0.x = p.x;
            } else if (p.x > rectangle.p1.x) {
                rectangle.p1.x = p.x;
            }
            if (p.y < rectangle.p0.y) {
                rectangle.p0.y = p.y;
                continue;
            }
            if (!(p.y > rectangle.p1.y)) continue;
            rectangle.p1.y = p.y;
        }
    }

    public static Point2D_F32 center(Quadrilateral_F32 quad, Point2D_F32 center) {
        if (center == null) {
            center = new Point2D_F32();
        }
        center.x = quad.a.x + quad.b.x + quad.c.x + quad.d.x;
        center.y = quad.a.y + quad.b.y + quad.c.y + quad.d.y;
        center.x /= 4.0f;
        center.y /= 4.0f;
        return center;
    }

    public static boolean isCCW(List<Point2D_F32> polygon) {
        int N = polygon.size();
        int sign = 0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            int k = (i + 2) % N;
            Point2D_F32 a = polygon.get(i);
            Point2D_F32 b = polygon.get(j);
            Point2D_F32 c = polygon.get(k);
            float dx0 = a.x - b.x;
            float dy1 = c.y - b.y;
            float dy0 = a.y - b.y;
            float dx1 = c.x - b.x;
            float z = dx0 * dy1 - dy0 * dx1;
            if (z > 0.0f) {
                ++sign;
                continue;
            }
            --sign;
        }
        return sign < 0;
    }

    public static boolean isCCW(Polygon2D_F32 polygon) {
        return UtilPolygons2D_F32.isCCW(polygon.vertexes.toList());
    }

    public static void vertexAverage(Polygon2D_F32 input, Point2D_F32 average) {
        average.setIdx(0, 0.0f);
        for (int i = 0; i < input.size(); ++i) {
            Point2D_F32 v = ((Point2D_F32[])input.vertexes.data)[i];
            average.x += v.x;
            average.y += v.y;
        }
        average.x /= (float)input.size();
        average.y /= (float)input.size();
    }

    public static boolean isIdentical(Polygon2D_F32 a, Polygon2D_F32 b, float tol) {
        if (a.size() != b.size()) {
            return false;
        }
        float tol2 = tol * tol;
        for (int i = 0; i < a.size(); ++i) {
            if (!(a.get(i).distance2(b.get(i)) > tol2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquivalent(Polygon2D_F32 a, Polygon2D_F32 b, float tol) {
        int i;
        if (a.size() != b.size()) {
            return false;
        }
        float tol2 = tol * tol;
        Point2D_F32 a0 = a.get(0);
        int match = -1;
        for (i = 0; i < b.size(); ++i) {
            if (!(a0.distance2(b.get(i)) <= tol2)) continue;
            match = i;
            break;
        }
        if (match < 0) {
            return false;
        }
        for (i = 1; i < b.size(); ++i) {
            Point2D_F32 bi;
            Point2D_F32 ai = a.get(i);
            if (!(ai.distance2(bi = b.get((match + i) % b.size())) > tol2)) continue;
            return false;
        }
        return true;
    }

    public static void flip(Polygon2D_F32 a) {
        int N = a.size();
        int H = N / 2;
        for (int i = 1; i <= H; ++i) {
            int j = N - i;
            Point2D_F32 tmp = ((Point2D_F32[])a.vertexes.data)[i];
            ((Point2D_F32[])a.vertexes.data)[i] = ((Point2D_F32[])a.vertexes.data)[j];
            ((Point2D_F32[])a.vertexes.data)[j] = tmp;
        }
    }

    public static void shiftUp(Polygon2D_F32 a) {
        int N = a.size();
        Point2D_F32 first = a.get(0);
        for (int i = 0; i < N - 1; ++i) {
            ((Point2D_F32[])a.vertexes.data)[i] = ((Point2D_F32[])a.vertexes.data)[i + 1];
        }
        ((Point2D_F32[])a.vertexes.data)[N - 1] = first;
    }

    public static void shiftDown(Polygon2D_F32 a) {
        int N = a.size();
        Point2D_F32 last = a.get(N - 1);
        for (int i = N - 1; i > 0; --i) {
            ((Point2D_F32[])a.vertexes.data)[i] = ((Point2D_F32[])a.vertexes.data)[i - 1];
        }
        ((Point2D_F32[])a.vertexes.data)[0] = last;
    }

    public static void convexHull(List<Point2D_F32> points, Polygon2D_F32 hull) {
        Point2D_F32[] array = new Point2D_F32[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            array[i] = points.get(i);
        }
        AndrewMonotoneConvexHull_F32 andrew = new AndrewMonotoneConvexHull_F32();
        andrew.process(array, array.length, hull);
    }

    public static void removeAlmostParallel(Polygon2D_F32 polygon, float tol) {
        int i = 0;
        while (i < polygon.vertexes.size()) {
            int j = (i + 1) % polygon.vertexes.size();
            int k = (i + 2) % polygon.vertexes.size();
            Point2D_F32 p0 = (Point2D_F32)polygon.vertexes.get(i);
            Point2D_F32 p1 = (Point2D_F32)polygon.vertexes.get(j);
            Point2D_F32 p2 = (Point2D_F32)polygon.vertexes.get(k);
            float angle = UtilVector2D_F32.acute(p1.x - p0.x, p1.y - p0.y, p2.x - p1.x, p2.y - p1.y);
            if (angle <= tol) {
                polygon.vertexes.remove(j);
                if (j >= i) continue;
                i = polygon.vertexes.size() - 1;
                continue;
            }
            ++i;
        }
    }

    public static void removeAdjacentDuplicates(Polygon2D_F32 polygon, float tol) {
        int i = polygon.vertexes.size() - 1;
        int j = 0;
        while (i >= 0 && polygon.size() > 1) {
            if (polygon.get(i).isIdentical(polygon.get(j), tol)) {
                polygon.vertexes.remove(i);
            }
            j = i--;
        }
    }

    public static boolean hasAdjacentDuplicates(Polygon2D_F32 polygon, float tol) {
        int i = polygon.vertexes.size() - 1;
        int j = 0;
        while (i >= 0 && polygon.size() > 1) {
            if (polygon.get(i).isIdentical(polygon.get(j), tol)) {
                return true;
            }
            j = i--;
        }
        return false;
    }

    public static float averageOfClosestPointError(Polygon2D_F32 model, Polygon2D_F32 target, int numberOfSamples) {
        LineSegment2D_F32 line = new LineSegment2D_F32();
        float[] cornerLocationsB = new float[target.size() + 1];
        float totalLength = 0.0f;
        for (int i = 0; i < target.size(); ++i) {
            Point2D_F32 b0 = target.get(i % target.size());
            Point2D_F32 b1 = target.get((i + 1) % target.size());
            cornerLocationsB[i] = totalLength;
            totalLength += b0.distance(b1);
        }
        cornerLocationsB[target.size()] = totalLength;
        Point2D_F32 pointOnB = new Point2D_F32();
        float error = 0.0f;
        int cornerB = 0;
        for (int k = 0; k < numberOfSamples; ++k) {
            float location = totalLength * (float)k / (float)numberOfSamples;
            while (location > cornerLocationsB[cornerB + 1]) {
                ++cornerB;
            }
            Point2D_F32 b0 = target.get(cornerB);
            Point2D_F32 b1 = target.get((cornerB + 1) % target.size());
            float locationCornerB = cornerLocationsB[cornerB];
            float fraction = (location - locationCornerB) / (cornerLocationsB[cornerB + 1] - locationCornerB);
            pointOnB.x = (b1.x - b0.x) * fraction + b0.x;
            pointOnB.y = (b1.y - b0.y) * fraction + b0.y;
            float best = Float.MAX_VALUE;
            for (int i = 0; i < model.size() + 1; ++i) {
                line.a = model.get(i % model.size());
                line.b = model.get((i + 1) % model.size());
                float d = Distance2D_F32.distance(line, pointOnB);
                if (!(d < best)) continue;
                best = d;
            }
            error += best;
        }
        return error / (float)numberOfSamples;
    }
}

