/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Vector2D_F32;

public class UtilVector2D_F32 {
    public static float acute(Vector2D_F32 a, Vector2D_F32 b) {
        float dot = a.dot(b);
        float value = dot / (a.norm() * b.norm());
        if (value > 1.0f) {
            value = 1.0f;
        } else if (value < -1.0f) {
            value = -1.0f;
        }
        return (float)Math.acos(value);
    }

    public static float acute(float ax, float ay, float bx, float by) {
        float nb;
        float dot = ax * bx + ay * by;
        float na = (float)Math.sqrt(ax * ax + ay * ay);
        float value = dot / (na * (nb = (float)Math.sqrt(bx * bx + by * by)));
        if (value > 1.0f) {
            value = 1.0f;
        } else if (value < -1.0f) {
            value = -1.0f;
        }
        return (float)Math.acos(value);
    }

    public static Vector2D_F32 minus(Point2D_F32 a, Point2D_F32 b, Vector2D_F32 output) {
        if (output == null) {
            output = new Vector2D_F32();
        }
        output.x = a.x - b.x;
        output.y = a.y - b.y;
        return output;
    }

    public static boolean identicalSign(float xa, float ya, float xb, float yb, float tol) {
        float dx0 = xb - xa;
        float dy0 = yb - ya;
        float error0 = dx0 * dx0 + dy0 * dy0;
        float dx1 = xb + xa;
        float dy1 = yb + ya;
        float error1 = dx1 * dx1 + dy1 * dy1;
        if (error0 < error1) {
            return error0 <= tol * tol;
        }
        return error1 <= tol * tol;
    }
}

