/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.geometry.UtilPoint2D_F32;
import georegression.metric.ClosestPoint2D_F32;
import georegression.struct.curve.EllipseRotated_F32;
import georegression.struct.line.LineGeneral2D_F32;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.Polygon2D_F32;
import georegression.struct.shapes.Quadrilateral_F32;

public class Distance2D_F32 {
    public static float distance(LineParametric2D_F32 line, Point2D_F32 p) {
        return (float)Math.sqrt(Distance2D_F32.distanceSq(line, p));
    }

    public static float distance(LineParametric2D_F32 line, float x, float y) {
        return (float)Math.sqrt(Distance2D_F32.distanceSq(line, x, y));
    }

    public static float distanceSq(LineParametric2D_F32 line, Point2D_F32 p) {
        float scale = Math.max(Math.abs(line.slope.x), Math.abs(line.slope.y));
        float t = ClosestPoint2D_F32.closestPointT(line, p, scale);
        float a = line.slope.x / scale * t + line.p.x;
        float b = line.slope.y / scale * t + line.p.y;
        float dx = p.x - a;
        float dy = p.y - b;
        return dx * dx + dy * dy;
    }

    public static float distanceSq(LineParametric2D_F32 line, float x, float y) {
        float scale = Math.max(Math.abs(line.slope.x), Math.abs(line.slope.y));
        float t = ClosestPoint2D_F32.closestPointT(line, x, y, scale);
        float a = line.slope.x / scale * t + line.p.x;
        float b = line.slope.y / scale * t + line.p.y;
        float dx = x - a;
        float dy = y - b;
        return dx * dx + dy * dy;
    }

    public static float distance(LineSegment2D_F32 line, Point2D_F32 p) {
        return (float)Math.sqrt(Distance2D_F32.distanceSq(line, p));
    }

    public static float distance(LineSegment2D_F32 line, float x, float y) {
        return (float)Math.sqrt(Distance2D_F32.distanceSq(line, x, y));
    }

    public static float distanceSq(LineSegment2D_F32 line, Point2D_F32 p) {
        float a = line.b.x - line.a.x;
        float b = line.b.y - line.a.y;
        float t = a * (p.x - line.a.x) + b * (p.y - line.a.y);
        if ((t /= a * a + b * b) < 0.0f) {
            return UtilPoint2D_F32.distanceSq(line.a.x, line.a.y, p.x, p.y);
        }
        if (t > 1.0f) {
            return UtilPoint2D_F32.distanceSq(line.b.x, line.b.y, p.x, p.y);
        }
        return UtilPoint2D_F32.distanceSq(line.a.x + t * a, line.a.y + t * b, p.x, p.y);
    }

    public static float distanceSq(LineSegment2D_F32 line, float x, float y) {
        float a = line.b.x - line.a.x;
        float b = line.b.y - line.a.y;
        float t = a * (x - line.a.x) + b * (y - line.a.y);
        if ((t /= a * a + b * b) < 0.0f) {
            return UtilPoint2D_F32.distanceSq(line.a.x, line.a.y, x, y);
        }
        if (t > 1.0f) {
            return UtilPoint2D_F32.distanceSq(line.b.x, line.b.y, x, y);
        }
        return UtilPoint2D_F32.distanceSq(line.a.x + t * a, line.a.y + t * b, x, y);
    }

    public static float distance(LineSegment2D_F32 segmentA, LineSegment2D_F32 segmentB) {
        return (float)Math.sqrt(Distance2D_F32.distanceSq(segmentA, segmentB));
    }

    public static float distanceSq(LineSegment2D_F32 segmentA, LineSegment2D_F32 segmentB) {
        float slopeAX = segmentA.slopeX();
        float slopeAY = segmentA.slopeY();
        float slopeBX = segmentB.slopeX();
        float slopeBY = segmentB.slopeY();
        float ta = slopeBX * (segmentA.a.y - segmentB.a.y) - slopeBY * (segmentA.a.x - segmentB.a.x);
        float bottom = slopeBY * slopeAX - slopeAY * slopeBX;
        if (bottom != 0.0f && (ta /= bottom) >= 0.0f && ta <= 1.0f) {
            float tb = slopeAX * (segmentB.a.y - segmentA.a.y) - slopeAY * (segmentB.a.x - segmentA.a.x);
            if ((tb /= slopeAY * slopeBX - slopeBY * slopeAX) >= 0.0f && tb <= 1.0f) {
                return 0.0f;
            }
        }
        float closest = Float.MAX_VALUE;
        closest = Math.min(closest, Distance2D_F32.distanceSq(segmentA, segmentB.a));
        closest = Math.min(closest, Distance2D_F32.distanceSq(segmentA, segmentB.b));
        closest = Math.min(closest, Distance2D_F32.distanceSq(segmentB, segmentA.a));
        closest = Math.min(closest, Distance2D_F32.distanceSq(segmentB, segmentA.b));
        return closest;
    }

    public static float distance(Quadrilateral_F32 quad, Point2D_F32 p) {
        return (float)Math.sqrt(Distance2D_F32.distanceSq(quad, p));
    }

    public static float distanceSq(Quadrilateral_F32 quad, Point2D_F32 p) {
        LineSegment2D_F32 seg = LineSegment2D_F32.wrap(quad.a, quad.b);
        float a = Distance2D_F32.distanceSq(seg, p);
        seg.a = quad.b;
        seg.b = quad.c;
        a = Math.min(a, Distance2D_F32.distanceSq(seg, p));
        seg.a = quad.c;
        seg.b = quad.d;
        a = Math.min(a, Distance2D_F32.distanceSq(seg, p));
        seg.a = quad.d;
        seg.b = quad.a;
        return Math.min(a, Distance2D_F32.distanceSq(seg, p));
    }

    public static float distance(Polygon2D_F32 poly, Point2D_F32 p) {
        return (float)Math.sqrt(Distance2D_F32.distanceSq(poly, p, null));
    }

    public static float distanceSq(Polygon2D_F32 poly, Point2D_F32 p, LineSegment2D_F32 storage) {
        if (storage == null) {
            storage = LineSegment2D_F32.wrap(null, null);
        }
        float minimum = Float.MAX_VALUE;
        for (int i = 0; i < poly.size(); ++i) {
            int j = (i + 1) % poly.size();
            storage.a = ((Point2D_F32[])poly.vertexes.data)[i];
            storage.b = ((Point2D_F32[])poly.vertexes.data)[j];
            float d = Distance2D_F32.distanceSq(storage, p);
            if (!(d < minimum)) continue;
            minimum = d;
        }
        return minimum;
    }

    public static float distance(LineGeneral2D_F32 line, Point2D_F32 p) {
        return Math.abs(line.A * p.x + line.B * p.y + line.C) / (float)Math.sqrt(line.A * line.A + line.B * line.B);
    }

    public static float distanceNorm(LineGeneral2D_F32 line, Point2D_F32 p) {
        return Math.abs(line.A * p.x + line.B * p.y + line.C);
    }

    public static float distanceOrigin(LineParametric2D_F32 line) {
        float top = line.slope.y * line.p.x - line.slope.x * line.p.y;
        return Math.abs(top) / line.slope.norm();
    }

    public static float distance(EllipseRotated_F32 ellipse, Point2D_F32 p) {
        return (float)Math.sqrt(Distance2D_F32.distance2(ellipse, p));
    }

    public static float distance2(EllipseRotated_F32 ellipse, Point2D_F32 p) {
        float cphi = (float)Math.cos(ellipse.phi);
        float sphi = (float)Math.sin(ellipse.phi);
        float xc = p.x - ellipse.center.x;
        float yc = p.y - ellipse.center.y;
        float r = (float)Math.sqrt(xc * xc + yc * yc);
        float x = cphi * xc + sphi * yc;
        float y = -sphi * xc + cphi * yc;
        float ct = x / r;
        float st = y / r;
        x = ellipse.center.x + ellipse.a * ct * cphi - ellipse.b * st * sphi;
        y = ellipse.center.y + ellipse.a * ct * sphi + ellipse.b * st * cphi;
        return p.distance2(x, y);
    }
}

