/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.geometry.UtilEllipse_F32;
import georegression.geometry.algs.AreaIntersectionPolygon2D_F32;
import georegression.misc.GrlConstants;
import georegression.struct.curve.EllipseRotated_F32;
import georegression.struct.line.LineGeneral2D_F32;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.shapes.Polygon2D_F32;
import georegression.struct.shapes.Quadrilateral_F32;
import georegression.struct.shapes.Rectangle2D_F32;
import georegression.struct.shapes.RectangleLength2D_F32;

public class Intersection2D_F32 {
    public static boolean containConvex(Polygon2D_F32 polygon, Point2D_F32 pt) {
        int N = polygon.size();
        boolean c = false;
        int i = 0;
        int j = N - 1;
        while (i < N) {
            Point2D_F32 a = ((Point2D_F32[])polygon.vertexes.data)[i];
            Point2D_F32 b = ((Point2D_F32[])polygon.vertexes.data)[j];
            if (a.y > pt.y != b.y > pt.y && pt.x < (b.x - a.x) * (pt.y - a.y) / (b.y - a.y) + a.x) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    public static boolean containConcave(Polygon2D_F32 polygon, Point2D_F32 pt) {
        int N = polygon.size();
        int left = 0;
        int right = 0;
        for (int i = 0; i < N - 1; ++i) {
            float x;
            Point2D_F32 a = ((Point2D_F32[])polygon.vertexes.data)[i];
            Point2D_F32 b = ((Point2D_F32[])polygon.vertexes.data)[i + 1];
            if (!(pt.y >= a.y && pt.y < b.y) && (!(pt.y >= b.y) || !(pt.y < a.y))) continue;
            float f = x = b.y == a.y ? pt.x : (pt.y - a.y) * (b.x - a.x) / (b.y - a.y) + a.x;
            if (x <= pt.x) {
                ++left;
                continue;
            }
            if (!(x > pt.x)) continue;
            ++right;
        }
        Point2D_F32 a = ((Point2D_F32[])polygon.vertexes.data)[N - 1];
        Point2D_F32 b = ((Point2D_F32[])polygon.vertexes.data)[0];
        if (pt.y >= a.y && pt.y < b.y || pt.y >= b.y && pt.y < a.y) {
            float x;
            float f = x = b.y == a.y ? pt.x : (pt.y - pt.y) * (b.x - a.x) / (b.y - a.y) + a.x;
            if (x <= pt.x) {
                ++left;
            } else if (x > pt.x) {
                ++right;
            }
        }
        return left % 2 == 1 && right % 2 == 1;
    }

    public static boolean contains(Quadrilateral_F32 quad, Point2D_F32 pt) {
        return Intersection2D_F32.containTriangle(quad.a, quad.b, quad.d, pt) || Intersection2D_F32.containTriangle(quad.b, quad.c, quad.d, pt);
    }

    public static boolean containTriangle(Point2D_F32 a, Point2D_F32 b, Point2D_F32 c, Point2D_F32 pt) {
        boolean ret = false;
        if (a.y > pt.y != b.y > pt.y && pt.x < (b.x - a.x) * (pt.y - a.y) / (b.y - a.y) + a.x) {
            ret = true;
        }
        if (b.y > pt.y != c.y > pt.y && pt.x < (c.x - b.x) * (pt.y - b.y) / (c.y - b.y) + b.x) {
            ret = !ret;
        }
        if (c.y > pt.y != a.y > pt.y && pt.x < (a.x - c.x) * (pt.y - c.y) / (a.y - c.y) + c.x) {
            ret = !ret;
        }
        return ret;
    }

    public static Point2D_F32 intersection(LineParametric2D_F32 a, LineParametric2D_F32 b, Point2D_F32 ret) {
        float t_b = a.getSlopeX() * (b.getY() - a.getY()) - a.getSlopeY() * (b.getX() - a.getX());
        float bottom = a.getSlopeY() * b.getSlopeX() - b.getSlopeY() * a.getSlopeX();
        if (bottom == 0.0f) {
            return null;
        }
        float x = b.getSlopeX() * (t_b /= bottom) + b.getX();
        float y = b.getSlopeY() * t_b + b.getY();
        if (ret == null) {
            ret = new Point2D_F32();
        }
        ret.set(x, y);
        return ret;
    }

    public static float intersection(LineParametric2D_F32 a, LineParametric2D_F32 b) {
        float t_a = b.getSlopeX() * (a.getY() - b.getY()) - b.getSlopeY() * (a.getX() - b.getX());
        float bottom = b.getSlopeY() * a.getSlopeX() - a.getSlopeY() * b.getSlopeX();
        if (bottom == 0.0f) {
            return Float.NaN;
        }
        return t_a / bottom;
    }

    public static Point2D_F32 intersection(LineSegment2D_F32 l_0, LineSegment2D_F32 l_1, Point2D_F32 ret) {
        float a0 = l_0.b.x - l_0.a.x;
        float b0 = l_0.b.y - l_0.a.y;
        float a1 = l_1.b.x - l_1.a.x;
        float b1 = l_1.b.y - l_1.a.y;
        float top = b0 * (l_1.a.x - l_0.a.x) + a0 * (l_0.a.y - l_1.a.y);
        float bottom = a0 * b1 - b0 * a1;
        if (bottom == 0.0f) {
            return null;
        }
        float t_1 = top / bottom;
        if (t_1 < 0.0f || t_1 > 1.0f) {
            return null;
        }
        top = b1 * (l_0.a.x - l_1.a.x) + a1 * (l_1.a.y - l_0.a.y);
        bottom = a1 * b0 - b1 * a0;
        float t_0 = top / bottom;
        if (t_0 < 0.0f || t_0 > 1.0f) {
            return null;
        }
        if (ret == null) {
            ret = new Point2D_F32();
        }
        ret.set(l_1.a.x + a1 * t_1, l_1.a.y + b1 * t_1);
        return ret;
    }

    public static Point3D_F32 intersection(LineGeneral2D_F32 a, LineGeneral2D_F32 b, Point3D_F32 ret) {
        if (ret == null) {
            ret = new Point3D_F32();
        }
        ret.x = a.B * b.C - a.C * b.B;
        ret.y = a.C * b.A - a.A * b.C;
        ret.z = a.A * b.B - a.B * b.A;
        return ret;
    }

    public static Point2D_F32 intersection(LineGeneral2D_F32 a, LineGeneral2D_F32 b, Point2D_F32 ret) {
        if (ret == null) {
            ret = new Point2D_F32();
        }
        ret.x = a.B * b.C - a.C * b.B;
        ret.y = a.C * b.A - a.A * b.C;
        float z = a.A * b.B - a.B * b.A;
        if (z == 0.0f) {
            return null;
        }
        ret.x /= z;
        ret.y /= z;
        return ret;
    }

    public static Point2D_F32 intersection(Point2D_F32 lineA0, Point2D_F32 lineA1, Point2D_F32 lineB0, Point2D_F32 lineB1, Point2D_F32 output) {
        if (output == null) {
            output = new Point2D_F32();
        }
        float slopeAx = lineA1.x - lineA0.x;
        float slopeAy = lineA1.y - lineA0.y;
        float slopeBx = lineB1.x - lineB0.x;
        float slopeBy = lineB1.y - lineB0.y;
        float top = slopeAy * (lineB0.x - lineA0.x) + slopeAx * (lineA0.y - lineB0.y);
        float bottom = slopeAx * slopeBy - slopeAy * slopeBx;
        if (bottom == 0.0f) {
            return null;
        }
        float t = top / bottom;
        output.x = lineB0.x + t * slopeBx;
        output.y = lineB0.y + t * slopeBy;
        return output;
    }

    public static float intersection(LineParametric2D_F32 target, LineSegment2D_F32 l) {
        float a1 = l.b.x - l.a.x;
        float b1 = l.b.y - l.a.y;
        float top = target.slope.y * (l.a.x - target.p.x) + target.slope.x * (target.p.y - l.a.y);
        float bottom = target.slope.x * b1 - target.slope.y * a1;
        if (bottom == 0.0f) {
            return Float.NaN;
        }
        float t_1 = top / bottom;
        if (t_1 < 0.0f || t_1 > 1.0f) {
            return Float.NaN;
        }
        top = b1 * (target.p.x - l.a.x) + a1 * (l.a.y - target.p.y);
        bottom = a1 * target.slope.y - b1 * target.slope.x;
        return top / bottom;
    }

    public static float intersection(Polygon2D_F32 a, Polygon2D_F32 b) {
        AreaIntersectionPolygon2D_F32 alg = new AreaIntersectionPolygon2D_F32();
        return Math.abs(alg.computeArea(a, b));
    }

    public static boolean contains(RectangleLength2D_F32 a, float x, float y) {
        if (a.getX() <= x && a.getX() + a.getWidth() > x) {
            return a.getY() <= y && a.getY() + a.getHeight() > y;
        }
        return false;
    }

    public static boolean contains2(RectangleLength2D_F32 a, float x, float y) {
        if (a.getX() <= x && a.getX() + a.getWidth() >= x) {
            return a.getY() <= y && a.getY() + a.getHeight() >= y;
        }
        return false;
    }

    public static boolean contains(Rectangle2D_F32 a, float x, float y) {
        return a.p0.x <= x && a.p1.x > x && a.p0.y <= y && a.p1.y > y;
    }

    public static boolean contains2(Rectangle2D_F32 a, float x, float y) {
        return a.p0.x <= x && a.p1.x >= x && a.p0.y <= y && a.p1.y >= y;
    }

    public static boolean contains(EllipseRotated_F32 ellipse, float x, float y) {
        return UtilEllipse_F32.evaluate(x, y, ellipse) <= 1.0f;
    }

    public static RectangleLength2D_F32 intersection(RectangleLength2D_F32 a, RectangleLength2D_F32 b) {
        float h;
        float tl_y;
        float w;
        float tl_x;
        if (a.getX() >= b.getX()) {
            if (a.getX() >= b.getX() + b.getWidth()) {
                return null;
            }
            tl_x = a.getX();
            w = b.getX() + b.getWidth() - a.getX();
        } else {
            if (a.getX() + a.getWidth() <= b.getX()) {
                return null;
            }
            tl_x = b.getX();
            w = a.getX() + a.getWidth() - b.getX();
        }
        if (a.getY() >= b.getY()) {
            if (a.getY() >= b.getY() + b.getHeight()) {
                return null;
            }
            tl_y = a.getY();
            h = b.getY() + b.getHeight() - a.getY();
        } else {
            if (a.getY() + a.getHeight() <= b.getY()) {
                return null;
            }
            tl_y = b.getY();
            h = a.getY() + a.getHeight() - b.getY();
        }
        return new RectangleLength2D_F32(tl_x, tl_y, w, h);
    }

    public static boolean intersects(Rectangle2D_F32 a, Rectangle2D_F32 b) {
        return a.p0.x < b.p1.x && a.p1.x > b.p0.x && a.p0.y < b.p1.y && a.p1.y > b.p0.y;
    }

    public static boolean intersection(Rectangle2D_F32 a, Rectangle2D_F32 b, Rectangle2D_F32 result) {
        if (!Intersection2D_F32.intersects(a, b)) {
            return false;
        }
        result.p0.x = Math.max(a.p0.x, b.p0.x);
        result.p1.x = Math.min(a.p1.x, b.p1.x);
        result.p0.y = Math.max(a.p0.y, b.p0.y);
        result.p1.y = Math.min(a.p1.y, b.p1.y);
        return true;
    }

    public static float intersectionArea(Rectangle2D_F32 a, Rectangle2D_F32 b) {
        if (!Intersection2D_F32.intersects(a, b)) {
            return 0.0f;
        }
        float x0 = Math.max(a.p0.x, b.p0.x);
        float x1 = Math.min(a.p1.x, b.p1.x);
        float y0 = Math.max(a.p0.y, b.p0.y);
        float y1 = Math.min(a.p1.y, b.p1.y);
        return (x1 - x0) * (y1 - y0);
    }

    public static int intersection(LineGeneral2D_F32 line, EllipseRotated_F32 ellipse, Point2D_F32 intersection0, Point2D_F32 intersection1, float EPS) {
        float x1;
        float x0;
        float y1;
        float y0;
        int totalIntersections;
        if (EPS < 0.0f) {
            EPS = GrlConstants.F_EPS;
        }
        float C = line.C + (line.A * ellipse.center.x + line.B * ellipse.center.y);
        float cphi = (float)Math.cos(ellipse.phi);
        float sphi = (float)Math.sin(ellipse.phi);
        float A = line.A * cphi + line.B * sphi;
        float B = -line.A * sphi + line.B * cphi;
        float a2 = ellipse.a * ellipse.a;
        float b2 = ellipse.b * ellipse.b;
        if (Math.abs(A) > Math.abs(B)) {
            float alpha = -C / A;
            float beta = -B / A;
            float bb = 2.0f * alpha * beta / a2;
            float aa = beta * beta / a2 + 1.0f / b2;
            float cc = alpha * alpha / a2 - 1.0f;
            float inner = bb * bb - 4.0f * aa * cc;
            if (Math.abs(inner / aa) < EPS) {
                totalIntersections = 1;
                inner = inner < 0.0f ? 0.0f : inner;
            } else {
                if (inner < 0.0f) {
                    return 0;
                }
                totalIntersections = 2;
            }
            float right = (float)Math.sqrt(inner);
            y0 = (-bb + right) / (2.0f * aa);
            y1 = (-bb - right) / (2.0f * aa);
            x0 = -(C + B * y0) / A;
            x1 = -(C + B * y1) / A;
        } else {
            float alpha = -C / B;
            float beta = -A / B;
            float bb = 2.0f * alpha * beta / b2;
            float aa = beta * beta / b2 + 1.0f / a2;
            float cc = alpha * alpha / b2 - 1.0f;
            float inner = bb * bb - 4.0f * aa * cc;
            if (Math.abs(inner / aa) < EPS) {
                totalIntersections = 1;
                inner = inner < 0.0f ? 0.0f : inner;
            } else {
                if (inner < 0.0f) {
                    return 0;
                }
                totalIntersections = 2;
            }
            float right = (float)Math.sqrt(inner);
            x0 = (-bb + right) / (2.0f * aa);
            x1 = (-bb - right) / (2.0f * aa);
            y0 = -(A * x0 + C) / B;
            y1 = -(A * x1 + C) / B;
        }
        intersection0.x = x0 * cphi - y0 * sphi + ellipse.center.x;
        intersection0.y = x0 * sphi + y0 * cphi + ellipse.center.y;
        intersection1.x = x1 * cphi - y1 * sphi + ellipse.center.x;
        intersection1.y = x1 * sphi + y1 * cphi + ellipse.center.y;
        return totalIntersections;
    }
}

