/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.affine.Affine2D_F32;
import georegression.struct.affine.Affine2D_F64;
import georegression.struct.curve.EllipseQuadratic_F32;
import georegression.struct.curve.EllipseQuadratic_F64;
import georegression.struct.curve.EllipseRotated_F32;
import georegression.struct.curve.EllipseRotated_F64;
import georegression.struct.homography.Homography2D_F32;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector2D_F32;
import georegression.struct.point.Vector2D_F64;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se2_F32;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F32;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrix3x3;
import org.ejml.data.FMatrixRMaj;
import org.ejml.ops.ConvertMatrixData;

public class ConvertFloatType {
    public static Se3_F32 convert(Se3_F64 src, Se3_F32 dst) {
        if (dst == null) {
            dst = new Se3_F32();
        }
        ConvertMatrixData.convert((DMatrixRMaj)src.getR(), (FMatrixRMaj)dst.getR());
        ConvertFloatType.convert(src.T, dst.T);
        return dst;
    }

    public static Se3_F64 convert(Se3_F32 src, Se3_F64 dst) {
        if (dst == null) {
            dst = new Se3_F64();
        }
        ConvertMatrixData.convert((FMatrixRMaj)src.getR(), (DMatrixRMaj)dst.getR());
        ConvertFloatType.convert(src.T, dst.T);
        return dst;
    }

    public static Se2_F32 convert(Se2_F64 src, Se2_F32 dst) {
        if (dst == null) {
            dst = new Se2_F32();
        }
        dst.c = (float)src.c;
        dst.s = (float)src.s;
        ConvertFloatType.convert(src.T, dst.T);
        return dst;
    }

    public static Se2_F64 convert(Se2_F32 src, Se2_F64 dst) {
        if (dst == null) {
            dst = new Se2_F64();
        }
        dst.c = src.c;
        dst.s = src.s;
        ConvertFloatType.convert(src.T, dst.T);
        return dst;
    }

    public static Homography2D_F32 convert(Homography2D_F64 src, Homography2D_F32 dst) {
        if (dst == null) {
            dst = new Homography2D_F32();
        }
        ConvertMatrixData.convert((DMatrix3x3)src, (FMatrix3x3)dst);
        return dst;
    }

    public static Homography2D_F64 convert(Homography2D_F32 src, Homography2D_F64 dst) {
        if (dst == null) {
            dst = new Homography2D_F64();
        }
        ConvertMatrixData.convert((FMatrix3x3)src, (DMatrix3x3)dst);
        return dst;
    }

    public static Affine2D_F32 convert(Affine2D_F64 src, Affine2D_F32 dst) {
        if (dst == null) {
            dst = new Affine2D_F32();
        }
        dst.a11 = (float)src.a11;
        dst.a12 = (float)src.a12;
        dst.a21 = (float)src.a21;
        dst.a22 = (float)src.a22;
        dst.tx = (float)src.tx;
        dst.ty = (float)src.ty;
        return dst;
    }

    public static Affine2D_F64 convert(Affine2D_F32 src, Affine2D_F64 dst) {
        if (dst == null) {
            dst = new Affine2D_F64();
        }
        dst.a11 = src.a11;
        dst.a12 = src.a12;
        dst.a21 = src.a21;
        dst.a22 = src.a22;
        dst.tx = src.tx;
        dst.ty = src.ty;
        return dst;
    }

    public static Point3D_F32 convert(Point3D_F64 src, Point3D_F32 dst) {
        if (dst == null) {
            dst = new Point3D_F32();
        }
        dst.x = (float)src.x;
        dst.y = (float)src.y;
        dst.z = (float)src.z;
        return dst;
    }

    public static Point3D_F64 convert(Point3D_F32 src, Point3D_F64 dst) {
        if (dst == null) {
            dst = new Point3D_F64();
        }
        dst.x = src.x;
        dst.y = src.y;
        dst.z = src.z;
        return dst;
    }

    public static Point2D_F32 convert(Point2D_F64 src, Point2D_F32 dst) {
        if (dst == null) {
            dst = new Point2D_F32();
        }
        dst.x = (float)src.x;
        dst.y = (float)src.y;
        return dst;
    }

    public static Point2D_F64 convert(Point2D_F32 src, Point2D_F64 dst) {
        if (dst == null) {
            dst = new Point2D_F64();
        }
        dst.x = src.x;
        dst.y = src.y;
        return dst;
    }

    public static Vector3D_F32 convert(Vector3D_F64 src, Vector3D_F32 dst) {
        if (dst == null) {
            dst = new Vector3D_F32();
        }
        dst.x = (float)src.x;
        dst.y = (float)src.y;
        dst.z = (float)src.z;
        return dst;
    }

    public static Vector3D_F64 convert(Vector3D_F32 src, Vector3D_F64 dst) {
        if (dst == null) {
            dst = new Vector3D_F64();
        }
        dst.x = src.x;
        dst.y = src.y;
        dst.z = src.z;
        return dst;
    }

    public static Vector2D_F32 convert(Vector2D_F64 src, Vector2D_F32 dst) {
        if (dst == null) {
            dst = new Vector2D_F32();
        }
        dst.x = (float)src.x;
        dst.y = (float)src.y;
        return dst;
    }

    public static Vector2D_F64 convert(Vector2D_F32 src, Vector2D_F64 dst) {
        if (dst == null) {
            dst = new Vector2D_F64();
        }
        dst.x = src.x;
        dst.y = src.y;
        return dst;
    }

    public static EllipseRotated_F32 convert(EllipseRotated_F64 src, EllipseRotated_F32 dst) {
        if (dst == null) {
            dst = new EllipseRotated_F32();
        }
        ConvertFloatType.convert(src.center, dst.center);
        dst.a = (float)src.a;
        dst.b = (float)src.b;
        dst.phi = (float)src.phi;
        return dst;
    }

    public static EllipseRotated_F64 convert(EllipseRotated_F32 src, EllipseRotated_F64 dst) {
        if (dst == null) {
            dst = new EllipseRotated_F64();
        }
        ConvertFloatType.convert(src.center, dst.center);
        dst.a = src.a;
        dst.b = src.b;
        dst.phi = src.phi;
        return dst;
    }

    public static EllipseQuadratic_F32 convert(EllipseQuadratic_F64 src, EllipseQuadratic_F32 dst) {
        if (dst == null) {
            dst = new EllipseQuadratic_F32();
        }
        dst.A = (float)src.A;
        dst.B = (float)src.B;
        dst.C = (float)src.C;
        dst.D = (float)src.D;
        dst.E = (float)src.E;
        dst.F = (float)src.F;
        return dst;
    }

    public static EllipseQuadratic_F64 convert(EllipseQuadratic_F32 src, EllipseQuadratic_F64 dst) {
        if (dst == null) {
            dst = new EllipseQuadratic_F64();
        }
        dst.A = src.A;
        dst.B = src.B;
        dst.C = src.C;
        dst.D = src.D;
        dst.E = src.E;
        dst.F = src.F;
        return dst;
    }
}

