/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.GeoTuple_F32;
import java.text.DecimalFormat;
import java.util.Objects;
import org.ejml.UtilEjml;

public abstract class GeoTuple3D_F32<T extends GeoTuple3D_F32>
extends GeoTuple_F32<T> {
    public float x;
    public float y;
    public float z;

    public GeoTuple3D_F32(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public GeoTuple3D_F32() {
    }

    @Override
    public int getDimension() {
        return 3;
    }

    protected void _set(GeoTuple3D_F32 a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean isIdentical(float x, float y, float z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public boolean isIdentical(float x, float y, float z, float tol) {
        return Math.abs(this.x - x) <= tol && Math.abs(this.y - y) <= tol && Math.abs(this.z - z) <= tol;
    }

    @Override
    public boolean isIdentical(GeoTuple3D_F32 t, float tol) {
        return Math.abs(this.x - t.x) <= tol && Math.abs(this.y - t.y) <= tol && Math.abs(this.z - t.z) <= tol;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    @Override
    public float getIdx(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("Invalid index");
    }

    @Override
    public void setIdx(int index, float value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid index");
            }
        }
    }

    public void plusIP(GeoTuple3D_F32 a) {
        this.x += a.x;
        this.y += a.y;
        this.z += a.z;
    }

    public T plus(GeoTuple3D_F32 a) {
        GeoTuple3D_F32 ret = (GeoTuple3D_F32)this.createNewInstance();
        ret.x = this.x + a.x;
        ret.y = this.y + a.y;
        ret.z = this.z + a.z;
        return (T)ret;
    }

    public void timesIP(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public void scale(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public void divideIP(float scalar) {
        this.x /= scalar;
        this.y /= scalar;
        this.z /= scalar;
    }

    public T times(float scalar) {
        GeoTuple3D_F32 ret = (GeoTuple3D_F32)this.createNewInstance();
        ret.x = this.x * scalar;
        ret.y = this.y * scalar;
        ret.z = this.z * scalar;
        return (T)ret;
    }

    @Override
    public float norm() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @Override
    public float normSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distance(float x, float y, float z) {
        float dx = x - this.x;
        float dy = y - this.y;
        float dz = z - this.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public float distance(GeoTuple3D_F32 t) {
        float dx = t.x - this.x;
        float dy = t.y - this.y;
        float dz = t.z - this.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public float distance2(GeoTuple3D_F32 t) {
        float dx = t.x - this.x;
        float dy = t.y - this.y;
        float dz = t.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public void print() {
        System.out.println(this);
    }

    public boolean isNaN() {
        return Float.isNaN(this.x) || Float.isNaN(this.y) || Float.isNaN(this.z);
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoTuple3D_F32 p = (GeoTuple3D_F32)obj;
        return Float.compare(this.x, p.x) == 0 && Float.compare(this.y, p.y) == 0 && Float.compare(this.z, p.z) == 0;
    }

    protected String toString(String name) {
        DecimalFormat format = new DecimalFormat("#");
        String sx = UtilEjml.fancyString((double)this.x, (DecimalFormat)format, (int)11, (int)4);
        String sy = UtilEjml.fancyString((double)this.y, (DecimalFormat)format, (int)11, (int)4);
        String sz = UtilEjml.fancyString((double)this.z, (DecimalFormat)format, (int)11, (int)4);
        return name + "( " + sx + " , " + sy + " , " + sz + " )";
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }
}

