/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.curve;

import georegression.struct.curve.PolynomialCurve_F32;
import org.ejml.FancyPrint;

public class PolynomialCubic1D_F32
implements PolynomialCurve_F32 {
    public float a;
    public float b;
    public float c;
    public float d;

    public PolynomialCubic1D_F32() {
    }

    public PolynomialCubic1D_F32(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public float evaluate(float t) {
        return this.a + this.b * t + this.c * t * t + this.d * t * t * t;
    }

    public void set(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public void set(PolynomialCubic1D_F32 src) {
        this.a = src.a;
        this.b = src.b;
        this.c = src.c;
        this.d = src.d;
    }

    public String toString() {
        FancyPrint fp = new FancyPrint();
        return "PolynomialCubic1D_F32{a=" + fp.s((double)this.a) + ", b=" + fp.s((double)this.b) + ", c=" + fp.s((double)this.c) + ", d=" + fp.s((double)this.d) + '}';
    }

    @Override
    public float get(int coefficient) {
        switch (coefficient) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.d;
            }
        }
        throw new IllegalArgumentException("Coefficient out of range. " + coefficient);
    }

    @Override
    public void set(int coefficient, float value) {
        switch (coefficient) {
            case 0: {
                this.a = value;
                return;
            }
            case 1: {
                this.b = value;
                return;
            }
            case 2: {
                this.c = value;
                return;
            }
            case 3: {
                this.d = value;
                return;
            }
        }
        throw new IllegalArgumentException("Coefficient out of range. " + coefficient);
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    public int degree() {
        return 3;
    }
}

