/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.curve;

import georegression.struct.curve.PolynomialCurve_F32;
import org.ejml.FancyPrint;

public class PolynomialQuadratic1D_F32
implements PolynomialCurve_F32 {
    public float a;
    public float b;
    public float c;

    public PolynomialQuadratic1D_F32() {
    }

    public PolynomialQuadratic1D_F32(float a, float b, float c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public float evaluate(float t) {
        return this.a + this.b * t + this.c * t * t;
    }

    public void set(float a, float b, float c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public void set(PolynomialQuadratic1D_F32 src) {
        this.a = src.a;
        this.b = src.b;
        this.c = src.c;
    }

    public String toString() {
        FancyPrint fp = new FancyPrint();
        return "PolynomialQuadratic1D_F32{a=" + fp.p((double)this.a) + ", b=" + fp.p((double)this.b) + ", c=" + fp.p((double)this.c) + '}';
    }

    @Override
    public float get(int coefficient) {
        switch (coefficient) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
        }
        throw new IllegalArgumentException("Coefficient out of range. " + coefficient);
    }

    @Override
    public void set(int coefficient, float value) {
        switch (coefficient) {
            case 0: {
                this.a = value;
                return;
            }
            case 1: {
                this.b = value;
                return;
            }
            case 2: {
                this.c = value;
                return;
            }
        }
        throw new IllegalArgumentException("Coefficient out of range. " + coefficient);
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public int degree() {
        return 2;
    }
}

