/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.point;

import georegression.geometry.UtilVector2D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;

public class Vector2D_F64
extends GeoTuple2D_F64<Vector2D_F64> {
    public Vector2D_F64(GeoTuple2D_F64 orig) {
        this(orig.x, orig.y);
    }

    public Vector2D_F64(double x, double y) {
        this.set(x, y);
    }

    public Vector2D_F64() {
    }

    public Vector2D_F64(Vector2D_F64 pt) {
        this.set(pt.x, pt.y);
    }

    @Override
    public Vector2D_F64 createNewInstance() {
        return new Vector2D_F64();
    }

    public void set(Vector2D_F64 orig) {
        this._set(orig);
    }

    @Override
    public Vector2D_F64 copy() {
        return new Vector2D_F64(this);
    }

    public void normalize() {
        double r = this.norm();
        this.x /= r;
        this.y /= r;
    }

    public void minus(Point2D_F64 a, Point2D_F64 b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
    }

    public String toString() {
        return this.toString("V");
    }

    public double dot(Vector2D_F64 a) {
        return this.x * a.x + this.y * a.y;
    }

    public double acute(Vector2D_F64 a) {
        return UtilVector2D_F64.acute(this, a);
    }
}

