/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.se;

import georegression.geometry.ConvertRotation3D_F32;
import georegression.geometry.GeometryMath_F32;
import georegression.struct.EulerType;
import georegression.struct.RotationType;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.se.SpecialEuclidean;
import georegression.transform.se.SePointOps_F32;
import javax.annotation.Nullable;
import org.ejml.data.FMatrix1Row;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;

public class Se3_F32
implements SpecialEuclidean<Se3_F32> {
    public static final long serialVersionUID = 1L;
    public FMatrixRMaj R;
    public Vector3D_F32 T;

    public Se3_F32() {
        this.R = CommonOps_FDRM.identity((int)3);
        this.T = new Vector3D_F32();
    }

    public Se3_F32(FMatrixRMaj R, Vector3D_F32 T) {
        this(R, T, false);
    }

    public Se3_F32(FMatrixRMaj R, Vector3D_F32 T, boolean assign) {
        if (assign) {
            this.R = R;
            this.T = T;
        } else {
            this.R = R.copy();
            this.T = T.copy();
        }
    }

    @Override
    public void set(Se3_F32 se) {
        this.R.set((FMatrixD1)se.getR());
        this.T.set(se.getT());
    }

    public void setRotation(FMatrixRMaj R) {
        this.R.set((FMatrixD1)R);
    }

    public void setTranslation(Vector3D_F32 T) {
        this.T.set(T);
    }

    public void setTranslation(float x, float y, float z) {
        this.T.set(x, y, z);
    }

    public FMatrixRMaj getRotation() {
        return this.R;
    }

    public Vector3D_F32 getTranslation() {
        return this.T;
    }

    public FMatrixRMaj getR() {
        return this.R;
    }

    public Vector3D_F32 getT() {
        return this.T;
    }

    public float getX() {
        return this.T.getX();
    }

    public float getY() {
        return this.T.getY();
    }

    public float getZ() {
        return this.T.getZ();
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Se3_F32 createInstance() {
        return new Se3_F32();
    }

    @Override
    public Se3_F32 concat(Se3_F32 second, Se3_F32 result) {
        if (result == null) {
            result = new Se3_F32();
        }
        CommonOps_FDRM.mult((FMatrix1Row)second.getR(), (FMatrix1Row)this.getR(), (FMatrix1Row)result.getR());
        GeometryMath_F32.mult(second.getR(), this.getT(), result.getT());
        GeometryMath_F32.add(second.getT(), result.getT(), result.getT());
        return result;
    }

    @Override
    public Se3_F32 invert(Se3_F32 inverse) {
        if (inverse == null) {
            inverse = new Se3_F32();
        }
        GeometryMath_F32.multTran(this.R, this.T, inverse.T);
        GeometryMath_F32.changeSign(inverse.T);
        CommonOps_FDRM.transpose((FMatrixRMaj)this.R, (FMatrixRMaj)inverse.R);
        return inverse;
    }

    @Override
    public void reset() {
        CommonOps_FDRM.setIdentity((FMatrix1Row)this.R);
        this.T.set(0.0f, 0.0f, 0.0f);
    }

    public void set(float x, float y, float z, EulerType type, float rotA, float rotB, float rotC) {
        this.T.set(x, y, z);
        ConvertRotation3D_F32.eulerToMatrix(type, rotA, rotB, rotC, this.R);
    }

    public void set(float x, float y, float z, RotationType type, float A, float B, float C, float D) {
        this.T.set(x, y, z);
        switch (type) {
            case RODRIGUES: {
                ConvertRotation3D_F32.rodriguesToMatrix(A, B, C, D, this.R);
                break;
            }
            case QUATERNION: {
                ConvertRotation3D_F32.quaternionToMatrix(A, B, C, D, this.R);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type is not supported. " + (Object)((Object)type));
            }
        }
    }

    public Point3D_F32 transform(Point3D_F32 src, @Nullable Point3D_F32 dst) {
        return SePointOps_F32.transform(this, src, dst);
    }

    public Point3D_F32 transformReverse(Point3D_F32 src, @Nullable Point3D_F32 dst) {
        return SePointOps_F32.transformReverse(this, src, dst);
    }

    public Vector3D_F32 transform(Vector3D_F32 src, @Nullable Vector3D_F32 dst) {
        return GeometryMath_F32.mult(this.R, src, dst);
    }

    public Vector3D_F32 transformReverse(Vector3D_F32 src, @Nullable Vector3D_F32 dst) {
        return GeometryMath_F32.multTran(this.R, src, dst);
    }

    public Se3_F32 copy() {
        Se3_F32 ret = new Se3_F32();
        ret.set(this);
        return ret;
    }

    public String toString() {
        String ret = "Se3_F32: T = " + this.T.toString() + "\n";
        ret = ret + this.R;
        return ret;
    }

    public void print() {
        System.out.println(this);
    }
}

