/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.se;

import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.EulerType;
import georegression.struct.RotationType;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.SpecialEuclidean;
import georegression.transform.se.SePointOps_F64;
import javax.annotation.Nullable;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class Se3_F64
implements SpecialEuclidean<Se3_F64> {
    public static final long serialVersionUID = 1L;
    public DMatrixRMaj R;
    public Vector3D_F64 T;

    public Se3_F64() {
        this.R = CommonOps_DDRM.identity((int)3);
        this.T = new Vector3D_F64();
    }

    public Se3_F64(DMatrixRMaj R, Vector3D_F64 T) {
        this(R, T, false);
    }

    public Se3_F64(DMatrixRMaj R, Vector3D_F64 T, boolean assign) {
        if (assign) {
            this.R = R;
            this.T = T;
        } else {
            this.R = R.copy();
            this.T = T.copy();
        }
    }

    @Override
    public void set(Se3_F64 se) {
        this.R.set((DMatrixD1)se.getR());
        this.T.set(se.getT());
    }

    public void setRotation(DMatrixRMaj R) {
        this.R.set((DMatrixD1)R);
    }

    public void setTranslation(Vector3D_F64 T) {
        this.T.set(T);
    }

    public void setTranslation(double x, double y, double z) {
        this.T.set(x, y, z);
    }

    public DMatrixRMaj getRotation() {
        return this.R;
    }

    public Vector3D_F64 getTranslation() {
        return this.T;
    }

    public DMatrixRMaj getR() {
        return this.R;
    }

    public Vector3D_F64 getT() {
        return this.T;
    }

    public double getX() {
        return this.T.getX();
    }

    public double getY() {
        return this.T.getY();
    }

    public double getZ() {
        return this.T.getZ();
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Se3_F64 createInstance() {
        return new Se3_F64();
    }

    @Override
    public Se3_F64 concat(Se3_F64 second, Se3_F64 result) {
        if (result == null) {
            result = new Se3_F64();
        }
        CommonOps_DDRM.mult((DMatrix1Row)second.getR(), (DMatrix1Row)this.getR(), (DMatrix1Row)result.getR());
        GeometryMath_F64.mult(second.getR(), this.getT(), result.getT());
        GeometryMath_F64.add(second.getT(), result.getT(), result.getT());
        return result;
    }

    @Override
    public Se3_F64 invert(Se3_F64 inverse) {
        if (inverse == null) {
            inverse = new Se3_F64();
        }
        GeometryMath_F64.multTran(this.R, this.T, inverse.T);
        GeometryMath_F64.changeSign(inverse.T);
        CommonOps_DDRM.transpose((DMatrixRMaj)this.R, (DMatrixRMaj)inverse.R);
        return inverse;
    }

    @Override
    public void reset() {
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.R);
        this.T.set(0.0, 0.0, 0.0);
    }

    public void set(double x, double y, double z, EulerType type, double rotA, double rotB, double rotC) {
        this.T.set(x, y, z);
        ConvertRotation3D_F64.eulerToMatrix(type, rotA, rotB, rotC, this.R);
    }

    public void set(double x, double y, double z, RotationType type, double A, double B, double C, double D) {
        this.T.set(x, y, z);
        switch (type) {
            case RODRIGUES: {
                ConvertRotation3D_F64.rodriguesToMatrix(A, B, C, D, this.R);
                break;
            }
            case QUATERNION: {
                ConvertRotation3D_F64.quaternionToMatrix(A, B, C, D, this.R);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type is not supported. " + (Object)((Object)type));
            }
        }
    }

    public Point3D_F64 transform(Point3D_F64 src, @Nullable Point3D_F64 dst) {
        return SePointOps_F64.transform(this, src, dst);
    }

    public Point3D_F64 transformReverse(Point3D_F64 src, @Nullable Point3D_F64 dst) {
        return SePointOps_F64.transformReverse(this, src, dst);
    }

    public Vector3D_F64 transform(Vector3D_F64 src, @Nullable Vector3D_F64 dst) {
        return GeometryMath_F64.mult(this.R, src, dst);
    }

    public Vector3D_F64 transformReverse(Vector3D_F64 src, @Nullable Vector3D_F64 dst) {
        return GeometryMath_F64.multTran(this.R, src, dst);
    }

    public Se3_F64 copy() {
        Se3_F64 ret = new Se3_F64();
        ret.set(this);
        return ret;
    }

    public String toString() {
        String ret = "Se3_F64: T = " + this.T.toString() + "\n";
        ret = ret + this.R;
        return ret;
    }

    public void print() {
        System.out.println(this);
    }
}

