/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.se;

import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.EulerType;
import georegression.struct.affine.Affine2D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class SpecialEuclideanOps_F64 {
    public static void setToNoMotion(Se3_F64 se) {
        CommonOps_DDRM.setIdentity((DMatrix1Row)se.getR());
        se.getT().set(0.0, 0.0, 0.0);
    }

    public static Affine2D_F64 toAffine(Se2_F64 se, Affine2D_F64 affine) {
        if (affine == null) {
            affine = new Affine2D_F64();
        }
        affine.a11 = se.c;
        affine.a12 = -se.s;
        affine.a21 = se.s;
        affine.a22 = se.c;
        affine.tx = se.T.x;
        affine.ty = se.T.y;
        return affine;
    }

    public static DMatrixRMaj toHomogeneous(Se3_F64 se, DMatrixRMaj ret) {
        if (ret == null) {
            ret = new DMatrixRMaj(4, 4);
        } else {
            ret.set(3, 0, 0.0);
            ret.set(3, 1, 0.0);
            ret.set(3, 2, 0.0);
        }
        CommonOps_DDRM.insert((DMatrix)se.getR(), (DMatrix)ret, (int)0, (int)0);
        Vector3D_F64 T = se.getT();
        ret.set(0, 3, T.x);
        ret.set(1, 3, T.y);
        ret.set(2, 3, T.z);
        ret.set(3, 3, 1.0);
        return ret;
    }

    public static Se3_F64 toSe3(DMatrixRMaj H, Se3_F64 ret) {
        if (H.numCols != 4 || H.numRows != 4) {
            throw new IllegalArgumentException("The homogeneous matrix must be 4 by 4 by definition.");
        }
        if (ret == null) {
            ret = new Se3_F64();
        }
        ret.setTranslation(H.get(0, 3), H.get(1, 3), H.get(2, 3));
        CommonOps_DDRM.extract((DMatrix)H, (int)0, (int)3, (int)0, (int)3, (DMatrix)ret.getR(), (int)0, (int)0);
        return ret;
    }

    public static DMatrixRMaj toHomogeneous(Se2_F64 se, DMatrixRMaj ret) {
        if (ret == null) {
            ret = new DMatrixRMaj(3, 3);
        } else {
            ret.set(2, 0, 0.0);
            ret.set(2, 1, 0.0);
        }
        double c = se.getCosineYaw();
        double s = se.getSineYaw();
        ret.set(0, 0, c);
        ret.set(0, 1, -s);
        ret.set(1, 0, s);
        ret.set(1, 1, c);
        ret.set(0, 2, se.getX());
        ret.set(1, 2, se.getY());
        ret.set(2, 2, 1.0);
        return ret;
    }

    public static Se2_F64 toSe2(DMatrixRMaj H, Se2_F64 ret) {
        if (H.numCols != 3 || H.numRows != 3) {
            throw new IllegalArgumentException("The homogeneous matrix must be 3 by 3 by definition.");
        }
        if (ret == null) {
            ret = new Se2_F64();
        }
        ret.setTranslation(H.get(0, 2), H.get(1, 2));
        double c = H.get(0, 0);
        double s = H.get(1, 0);
        ret.setYaw(Math.atan2(s, c));
        return ret;
    }

    public static Se3_F64 eulerXyz(double dx, double dy, double dz, double rotX, double rotY, double rotZ, Se3_F64 se) {
        return SpecialEuclideanOps_F64.eulerXyz(dx, dy, dz, EulerType.XYZ, rotX, rotY, rotZ, se);
    }

    public static Se3_F64 eulerXyz(double dx, double dy, double dz, EulerType type, double rotX, double rotY, double rotZ, Se3_F64 se) {
        if (se == null) {
            se = new Se3_F64();
        }
        ConvertRotation3D_F64.eulerToMatrix(type, rotX, rotY, rotZ, se.getR());
        Vector3D_F64 T = se.getT();
        T.x = dx;
        T.y = dy;
        T.z = dz;
        return se;
    }

    public static Se3_F64 axisXyz(double dx, double dy, double dz, double rotX, double rotY, double rotZ, Se3_F64 se) {
        double theta;
        if (se == null) {
            se = new Se3_F64();
        }
        if ((theta = Math.sqrt(rotX * rotX + rotY + rotY + rotZ * rotZ)) == 0.0) {
            CommonOps_DDRM.setIdentity((DMatrix1Row)se.R);
        } else {
            ConvertRotation3D_F64.rodriguesToMatrix(rotX / theta, rotY / theta, rotZ / theta, theta, se.getR());
        }
        Vector3D_F64 T = se.getT();
        T.x = dx;
        T.y = dy;
        T.z = dz;
        return se;
    }

    public static Se3_F64 quatXyz(double dx, double dy, double dz, double qw, double qx, double qy, double qz, Se3_F64 se) {
        if (se == null) {
            se = new Se3_F64();
        }
        ConvertRotation3D_F64.quaternionToMatrix(qw, qx, qy, qz, se.getR());
        Vector3D_F64 T = se.getT();
        T.x = dx;
        T.y = dy;
        T.z = dz;
        return se;
    }

    public static boolean isIdentical(Se3_F64 a, Se3_F64 b, double tolT, double tolR) {
        if (Math.abs(a.T.x - b.T.x) > tolT) {
            return false;
        }
        if (Math.abs(a.T.y - b.T.y) > tolT) {
            return false;
        }
        if (Math.abs(a.T.z - b.T.z) > tolT) {
            return false;
        }
        DMatrixRMaj D = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.multTransA((DMatrix1Row)a.R, (DMatrix1Row)b.R, (DMatrix1Row)D);
        Rodrigues_F64 rod = new Rodrigues_F64();
        ConvertRotation3D_F64.matrixToRodrigues(D, rod);
        return rod.theta <= tolR;
    }

    public static boolean bestFit(Se3_F64 a) {
        SingularValueDecomposition_F64 svd = DecompositionFactory_DDRM.svd((boolean)true, (boolean)true, (boolean)true);
        if (!svd.decompose((Matrix)a.R)) {
            throw new RuntimeException("SVD Failed");
        }
        CommonOps_DDRM.multTransB((DMatrix1Row)((DMatrix1Row)svd.getU(null, false)), (DMatrix1Row)((DMatrix1Row)svd.getV(null, false)), (DMatrix1Row)a.R);
        double det = CommonOps_DDRM.det((DMatrixRMaj)a.R);
        if (det < 0.0) {
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)a.R);
        }
        double b = 1.0;
        double[] s = svd.getSingularValues();
        for (int i = 0; i < svd.numberOfSingularValues(); ++i) {
            b *= s[i];
        }
        b = Math.signum(det) / Math.pow(b, 0.3333333333333333);
        GeometryMath_F64.scale(a.T, b);
        return true;
    }
}

