/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.shapes;

import georegression.geometry.UtilPolygons2D_F32;
import georegression.metric.Area2D_F32;
import georegression.metric.Intersection2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.ddogleg.struct.FastQueue;
import org.ejml.UtilEjml;

public class Polygon2D_F32
implements Serializable {
    public FastQueue<Point2D_F32> vertexes;

    public Polygon2D_F32(float[][] a) {
        this(a.length);
        for (int i = 0; i < a.length; ++i) {
            ((Point2D_F32)this.vertexes.get(i)).set(a[i][0], a[i][1]);
        }
    }

    public Polygon2D_F32(Polygon2D_F32 a) {
        this.vertexes = new FastQueue(a.size(), Point2D_F32.class, true);
        for (int i = 0; i < a.size(); ++i) {
            ((Point2D_F32)this.vertexes.grow()).set(a.get(i));
        }
    }

    public Polygon2D_F32(int numVertexes) {
        this.vertexes = new FastQueue(numVertexes, Point2D_F32.class, true);
        this.vertexes.growArray(numVertexes);
        this.vertexes.size = numVertexes;
    }

    public Polygon2D_F32(float ... points) {
        if (points.length % 2 == 1) {
            throw new IllegalArgumentException("Expected an even number");
        }
        this.vertexes = new FastQueue(points.length / 2, Point2D_F32.class, true);
        this.vertexes.growArray(points.length / 2);
        this.vertexes.size = points.length / 2;
        int count = 0;
        for (int i = 0; i < points.length; i += 2) {
            ((Point2D_F32[])this.vertexes.data)[count++].set(points[i], points[i + 1]);
        }
    }

    public Polygon2D_F32() {
        this.vertexes = new FastQueue(Point2D_F32.class, true);
    }

    public void set(Polygon2D_F32 orig) {
        this.vertexes.resize(orig.size());
        for (int i = 0; i < orig.size(); ++i) {
            ((Point2D_F32[])this.vertexes.data)[i].set(((Point2D_F32[])orig.vertexes.data)[i]);
        }
    }

    public void set(int index, float x, float y) {
        ((Point2D_F32[])this.vertexes.data)[index].set(x, y);
    }

    public float getSideLength(int index) {
        Point2D_F32 a = (Point2D_F32)this.vertexes.get(index);
        Point2D_F32 b = (Point2D_F32)this.vertexes.get((index + 1) % this.vertexes.size);
        return a.distance(b);
    }

    public Point2D_F32 get(int index) {
        return ((Point2D_F32[])this.vertexes.data)[index];
    }

    public int size() {
        return this.vertexes.size();
    }

    public Polygon2D_F32 copy() {
        return new Polygon2D_F32(this);
    }

    public float areaSimple() {
        return Area2D_F32.polygonSimple(this);
    }

    public boolean isInside(Point2D_F32 p) {
        if (this.isConvex()) {
            return Intersection2D_F32.containConvex(this, p);
        }
        return Intersection2D_F32.containConcave(this, p);
    }

    public boolean isCCW() {
        return UtilPolygons2D_F32.isCCW(this.vertexes.toList());
    }

    public boolean isConvex() {
        return UtilPolygons2D_F32.isConvex(this);
    }

    public boolean isIdentical(Polygon2D_F32 a, float tol) {
        return UtilPolygons2D_F32.isIdentical(this, a, tol);
    }

    public boolean isEquivalent(Polygon2D_F32 a, float tol) {
        return UtilPolygons2D_F32.isEquivalent(this, a, tol);
    }

    public void flip() {
        UtilPolygons2D_F32.flip(this);
    }

    public LineSegment2D_F32 getLine(int index, LineSegment2D_F32 storage) {
        if (storage == null) {
            storage = new LineSegment2D_F32();
        }
        int j = (index + 1) % this.vertexes.size;
        storage.a.set(this.get(index));
        storage.b.set(this.get(j));
        return storage;
    }

    public List<Point2D_F32> convert(@Nullable List<Point2D_F32> storage, boolean copy) {
        if (storage == null) {
            storage = new ArrayList<Point2D_F32>();
        } else {
            storage.clear();
        }
        if (copy) {
            for (int i = 0; i < this.vertexes.size; ++i) {
                storage.add(((Point2D_F32)this.vertexes.get(i)).copy());
            }
        } else {
            storage.addAll(this.vertexes.toList());
        }
        return storage;
    }

    public void set(List<Point2D_F32> list) {
        this.vertexes.resize(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ((Point2D_F32[])this.vertexes.data)[i].set(list.get(i));
        }
    }

    public String toString() {
        int length = 11;
        DecimalFormat format = new DecimalFormat("#");
        String out = this.getClass().getSimpleName() + "{ order " + this.vertexes.size + " : vertexes [ ";
        for (int i = 0; i < this.vertexes.size; ++i) {
            Point2D_F32 p = (Point2D_F32)this.vertexes.get(i);
            out = out + "( " + UtilEjml.fancyStringF((double)p.x, (DecimalFormat)format, (int)11, (int)4) + " , " + UtilEjml.fancyStringF((double)p.y, (DecimalFormat)format, (int)11, (int)4) + " ) ";
        }
        out = out + "] }";
        return out;
    }
}

