/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform.se;

import java.util.List;
import org.ejml.data.FMatrix1Row;
import org.ejml.data.FMatrix3x3;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.fixed.CommonOps_FDF3;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.factory.DecompositionFactory_FDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F32;
import org.ejml.ops.ConvertFMatrixStruct;

public class AverageRotationMatrix_F32 {
    FMatrixRMaj M = new FMatrixRMaj(3, 3);
    FMatrix3x3 F = new FMatrix3x3();
    SingularValueDecomposition_F32<FMatrixRMaj> svd = DecompositionFactory_FDRM.svd((int)3, (int)3, (boolean)true, (boolean)true, (boolean)true);

    public boolean process(List<FMatrixRMaj> list, FMatrixRMaj average) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Input list is empty");
        }
        if (average == null) {
            throw new IllegalArgumentException("average is null");
        }
        this.M.zero();
        for (int i = 0; i < list.size(); ++i) {
            FMatrixRMaj m = list.get(i);
            this.M.data[0] = this.M.data[0] + m.data[0];
            this.M.data[1] = this.M.data[1] + m.data[1];
            this.M.data[2] = this.M.data[2] + m.data[2];
            this.M.data[3] = this.M.data[3] + m.data[3];
            this.M.data[4] = this.M.data[4] + m.data[4];
            this.M.data[5] = this.M.data[5] + m.data[5];
            this.M.data[6] = this.M.data[6] + m.data[6];
            this.M.data[7] = this.M.data[7] + m.data[7];
            this.M.data[8] = this.M.data[8] + m.data[8];
        }
        CommonOps_FDRM.divide((FMatrixD1)this.M, (float)list.size());
        if (!this.svd.decompose((Matrix)this.M)) {
            return false;
        }
        CommonOps_FDRM.multTransB((FMatrix1Row)((FMatrix1Row)this.svd.getU(null, false)), (FMatrix1Row)((FMatrix1Row)this.svd.getV(null, false)), (FMatrix1Row)average);
        float det = CommonOps_FDRM.det((FMatrixRMaj)average);
        if (det < 0.0f) {
            CommonOps_FDRM.scale((float)-1.0f, (FMatrixD1)average);
        }
        return true;
    }

    public boolean process(List<FMatrix3x3> list, FMatrix3x3 average) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Input list is empty");
        }
        if (average == null) {
            throw new IllegalArgumentException("average is null");
        }
        CommonOps_FDF3.fill((FMatrix3x3)this.F, (float)0.0f);
        for (int i = 0; i < list.size(); ++i) {
            FMatrix3x3 m = list.get(i);
            this.F.a11 += m.a11;
            this.F.a12 += m.a12;
            this.F.a13 += m.a13;
            this.F.a21 += m.a21;
            this.F.a22 += m.a22;
            this.F.a23 += m.a23;
            this.F.a31 += m.a31;
            this.F.a32 += m.a32;
            this.F.a33 += m.a33;
        }
        CommonOps_FDF3.divide((FMatrix3x3)this.F, (float)list.size());
        ConvertFMatrixStruct.convert((FMatrix3x3)this.F, (FMatrixRMaj)this.M);
        if (!this.svd.decompose((Matrix)this.M)) {
            return false;
        }
        CommonOps_FDRM.multTransB((FMatrix1Row)((FMatrix1Row)this.svd.getU(null, false)), (FMatrix1Row)((FMatrix1Row)this.svd.getV(null, false)), (FMatrix1Row)this.M);
        float det = CommonOps_FDRM.det((FMatrixRMaj)this.M);
        if (det < 0.0f) {
            CommonOps_FDRM.scale((float)-1.0f, (FMatrixD1)this.M);
        }
        ConvertFMatrixStruct.convert((FMatrixRMaj)this.M, (FMatrix3x3)average);
        return true;
    }
}

